/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.webrtc.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.webconferencing.WebConferencingService;
import org.exoplatform.webconferencing.client.ErrorInfo;
import org.exoplatform.webconferencing.webrtc.WebrtcProvider;
import org.json.JSONObject;

@Path(value="/webrtc/webconferencing")
@Produces(value={"application/json"})
@Api(tags={"/webrtc/webconferencing"}, value="/webrtc/webconferencing", description="Operations on WebRTC provider settings")
public class RESTWebRTCService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(RESTWebRTCService.class);
    protected final WebConferencingService webConferencing;
    private final CacheControl cacheControl;

    public RESTWebRTCService(WebConferencingService webConferencing) {
        this.webConferencing = webConferencing;
        this.cacheControl = new CacheControl();
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
    }

    @POST
    @RolesAllowed(value={"administrators"})
    @Path(value="/settings")
    @ApiOperation(value="Updates RTC configuration in WebRTC settings", httpMethod="POST", response=WebrtcProvider.RTCConfiguration.class, notes="Use this method to update RTC configuration of WebRTC provider. This operation only avalable to Administrator user.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled. Updated provider config returned.", response=WebrtcProvider.RTCConfiguration.class), @ApiResponse(code=401, message="Unauthorized user (conversation state not present). Error code: ACCESS_ERROR"), @ApiResponse(code=404, message="Provider (WebRTC) not found. Error code: NOT_FOUND_ERROR"), @ApiResponse(code=500, message="Internal server error due to data encoding or formatting result to JSON. Error code: SERVER_ERROR")})
    public Response postSettings(@Context UriInfo uriInfo, @ApiParam(value="RTC configuration in JSON format. See WebrtcProvider.jsonToRtcConfig() for details", required=true) @FormParam(value="rtcConfiguration") String rtcConfig) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            try {
                WebrtcProvider webrtc = (WebrtcProvider)this.webConferencing.getProvider("webrtc");
                if (webrtc != null) {
                    WebrtcProvider.RTCConfiguration conf = webrtc.jsonToRtcConfig(new JSONObject(rtcConfig));
                    webrtc.saveRtcConfiguration(conf);
                    return Response.ok().cacheControl(this.cacheControl).entity((Object)conf).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError((String)"WebRTC provider not found")).build();
            }
            catch (Throwable e) {
                LOG.error((Object)("Error saving WebRTC settings by '" + currentUserName + "'"), e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError((String)"Error saving WebRTC settings")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError((String)"Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"administrators"})
    @Path(value="/settings")
    @ApiOperation(value="Read WebRTC providers settings", httpMethod="GET", response=WebrtcProvider.RTCConfiguration.class, notes="Use this method to read WebRTC providers settings. This operation only avalable to Administrator user.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled. Settings object returned.", response=WebrtcProvider.RTCConfiguration.class), @ApiResponse(code=401, message="Unauthorized user (conversation state not present). Error code: ACCESS_ERROR"), @ApiResponse(code=404, message="Provider (WebRTC) not found. Error code: NOT_FOUND_ERROR"), @ApiResponse(code=500, message="Internal server error due to data encoding or formatting result to JSON. Error code: SERVER_ERROR")})
    public Response getSettings(@Context UriInfo uriInfo) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            try {
                WebrtcProvider webrtc = (WebrtcProvider)this.webConferencing.getProvider("webrtc");
                if (webrtc != null) {
                    return Response.ok().cacheControl(this.cacheControl).entity((Object)webrtc.getRtcConfiguration()).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(this.cacheControl).entity((Object)ErrorInfo.notFoundError((String)"WebRTC provider not found")).build();
            }
            catch (Throwable e) {
                LOG.error((Object)("Error getting WebRTC settings by '" + currentUserName + "'"), e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)ErrorInfo.serverError((String)"Error getting WebRTC settings")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)ErrorInfo.accessError((String)"Unauthorized user")).build();
    }
}

