/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.clean.rdbms.scripts;

import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanException;
import org.exoplatform.services.jcr.impl.clean.rdbms.scripts.DB2CleaningScipts;
import org.exoplatform.services.jcr.impl.clean.rdbms.scripts.DBCleaningScripts;
import org.exoplatform.services.jcr.impl.clean.rdbms.scripts.H2CleaningScipts;
import org.exoplatform.services.jcr.impl.clean.rdbms.scripts.HSQLDBCleaningScipts;
import org.exoplatform.services.jcr.impl.clean.rdbms.scripts.MSSQLCleaningScipts;
import org.exoplatform.services.jcr.impl.clean.rdbms.scripts.MySQLCleaningScipts;
import org.exoplatform.services.jcr.impl.clean.rdbms.scripts.OracleCleaningScipts;
import org.exoplatform.services.jcr.impl.clean.rdbms.scripts.PgSQLCleaningScipts;
import org.exoplatform.services.jcr.impl.clean.rdbms.scripts.SybaseCleaningScipts;

public class DBCleaningScriptsFactory {
    public static DBCleaningScripts prepareScripts(String dialect, WorkspaceEntry wsEntry) throws DBCleanException {
        if (dialect.startsWith("MYSQL")) {
            return new MySQLCleaningScipts(dialect, wsEntry);
        }
        if (dialect.startsWith("DB2")) {
            return new DB2CleaningScipts(dialect, wsEntry);
        }
        if (dialect.startsWith("MSSQL")) {
            return new MSSQLCleaningScipts(dialect, wsEntry);
        }
        if (dialect.startsWith("PGSQL")) {
            return new PgSQLCleaningScipts(dialect, wsEntry);
        }
        if (dialect.startsWith("SYBASE")) {
            return new SybaseCleaningScipts(dialect, wsEntry);
        }
        if (dialect.startsWith("HSQLDB")) {
            return new HSQLDBCleaningScipts(dialect, wsEntry);
        }
        if (dialect.startsWith("H2")) {
            return new H2CleaningScipts(dialect, wsEntry);
        }
        if (dialect.startsWith("ORACLE")) {
            return new OracleCleaningScipts(dialect, wsEntry);
        }
        throw new DBCleanException("Unsupported dialect " + dialect);
    }

    public static DBCleaningScripts prepareScripts(String dialect, RepositoryEntry rEntry) throws DBCleanException {
        if (dialect.startsWith("MYSQL")) {
            return new MySQLCleaningScipts(dialect, rEntry);
        }
        if (dialect.startsWith("DB2")) {
            return new DB2CleaningScipts(dialect, rEntry);
        }
        if (dialect.startsWith("MSSQL")) {
            return new MSSQLCleaningScipts(dialect, rEntry);
        }
        if (dialect.startsWith("PGSQL")) {
            return new PgSQLCleaningScipts(dialect, rEntry);
        }
        if (dialect.startsWith("SYBASE")) {
            return new SybaseCleaningScipts(dialect, rEntry);
        }
        if (dialect.startsWith("HSQLDB")) {
            return new HSQLDBCleaningScipts(dialect, rEntry);
        }
        if (dialect.startsWith("H2")) {
            return new H2CleaningScipts(dialect, rEntry);
        }
        if (dialect.startsWith("ORACLE")) {
            return new OracleCleaningScipts(dialect, rEntry);
        }
        throw new DBCleanException("Unsupported dialect " + dialect);
    }
}

