/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.Weight;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.ChildNodesQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.HierarchyResolver;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingConfiguration;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrIndexSearcher;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.MatchAllDocsQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.NodeTraversingQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNode;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScorerWrapper;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;
import org.exoplatform.services.jcr.impl.core.query.lucene.hits.AbstractHitCollector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

class DescendantSelfAxisQuery
extends Query
implements JcrQuery {
    private static final long serialVersionUID = -6384454109961093757L;
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.DescendantSelfAxisQuery");
    private final Query contextQuery;
    private Scorer contextScorer;
    private final Query subQuery;
    private final int minLevels;
    private Scorer subScorer;
    private IndexingConfiguration indexConfig;

    public DescendantSelfAxisQuery(Query context, boolean includeSelf, IndexingConfiguration indexConfig) {
        this(context, (Query)new MatchAllDocsQuery(indexConfig), includeSelf, indexConfig);
    }

    public DescendantSelfAxisQuery(Query context, Query sub, IndexingConfiguration indexConfig) {
        this(context, sub, true, indexConfig);
    }

    public DescendantSelfAxisQuery(Query context, Query sub, boolean includeSelf, IndexingConfiguration indexConfig) {
        this(context, sub, includeSelf ? 0 : 1, indexConfig);
    }

    public DescendantSelfAxisQuery(Query context, Query sub, int minLevels, IndexingConfiguration indexConfig) {
        this.contextQuery = context;
        this.subQuery = sub;
        this.minLevels = minLevels;
        this.indexConfig = indexConfig;
    }

    Query getContextQuery() {
        return this.contextQuery;
    }

    boolean subQueryMatchesAll() {
        return this.subQuery instanceof MatchAllDocsQuery;
    }

    int getMinLevels() {
        return this.minLevels;
    }

    public Weight createWeight(Searcher searcher) {
        return new DescendantSelfAxisWeight(searcher);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("DescendantSelfAxisQuery(");
        sb.append(this.contextQuery);
        sb.append(", ");
        sb.append(this.subQuery);
        sb.append(", ");
        sb.append(this.minLevels);
        sb.append(")");
        return sb.toString();
    }

    public void extractTerms(Set<Term> terms) {
        this.contextQuery.extractTerms(terms);
        this.subQuery.extractTerms(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        DescendantSelfAxisQuery dsaq;
        Query cQuery = this.contextQuery.rewrite(reader);
        Query sQuery = this.subQuery.rewrite(reader);
        if (this.contextQuery instanceof DescendantSelfAxisQuery && (dsaq = (DescendantSelfAxisQuery)this.contextQuery).subQueryMatchesAll()) {
            return new DescendantSelfAxisQuery(dsaq.getContextQuery(), sQuery, dsaq.getMinLevels() + this.getMinLevels(), this.indexConfig).rewrite(reader);
        }
        if (cQuery == this.contextQuery && sQuery == this.subQuery) {
            return this;
        }
        return new DescendantSelfAxisQuery(cQuery, sQuery, this.minLevels, this.indexConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryHits execute(JcrIndexSearcher searcher, final SessionImpl session, Sort sort) throws IOException {
        if (sort.getSort().length == 0 && this.subQueryMatchesAll()) {
            TreeMap<String, ScoreNode> startingPoints = new TreeMap<String, ScoreNode>();
            try (QueryHits result = searcher.evaluate(this.getContextQuery());){
                for (int i = 2; i <= this.getMinLevels(); ++i) {
                    result = new ChildNodesQueryHits(result, session, this.indexConfig);
                }
                try {
                    ScoreNode sn;
                    while ((sn = result.nextScoreNode()) != null) {
                        Node node = (Node)session.getTransientNodesManager().getItemByIdentifier(sn.getNodeId(), true);
                        startingPoints.put(node.getPath(), sn);
                    }
                }
                catch (RepositoryException e) {
                    throw Util.createIOException(e);
                }
            }
            String previousPath = null;
            Iterator it = startingPoints.keySet().iterator();
            while (it.hasNext()) {
                String path = (String)it.next();
                if (previousPath != null && path.startsWith(previousPath)) {
                    it.remove();
                    continue;
                }
                previousPath = path;
            }
            final Iterator scoreNodes = startingPoints.values().iterator();
            return new AbstractQueryHits(){
                private NodeTraversingQueryHits currentTraversal;
                {
                    this.fetchNextTraversal();
                }

                @Override
                public void close() throws IOException {
                    if (this.currentTraversal != null) {
                        this.currentTraversal.close();
                    }
                }

                @Override
                public ScoreNode nextScoreNode() throws IOException {
                    while (this.currentTraversal != null) {
                        ScoreNode sn = this.currentTraversal.nextScoreNode();
                        if (sn != null) {
                            return sn;
                        }
                        this.fetchNextTraversal();
                    }
                    return null;
                }

                private void fetchNextTraversal() throws IOException {
                    if (this.currentTraversal != null) {
                        this.currentTraversal.close();
                    }
                    if (scoreNodes.hasNext()) {
                        ScoreNode sn = (ScoreNode)scoreNodes.next();
                        try {
                            Node node = (Node)session.getTransientNodesManager().getItemByIdentifier(sn.getNodeId(), true);
                            this.currentTraversal = new NodeTraversingQueryHits(node, DescendantSelfAxisQuery.this.getMinLevels() == 0, DescendantSelfAxisQuery.this.indexConfig);
                        }
                        catch (RepositoryException e) {
                            throw Util.createIOException(e);
                        }
                    } else {
                        this.currentTraversal = null;
                    }
                }
            };
        }
        return null;
    }

    private class DescendantSelfAxisScorer
    extends Scorer {
        private final HierarchyResolver hResolver;
        private final BitSet contextHits;
        private boolean contextHitsCalculated;
        private int[] ancestorDocs;
        private int[] pDocs;
        private final int[] singleDoc;
        private int currentDoc;

        protected DescendantSelfAxisScorer(Similarity similarity, IndexReader reader, HierarchyResolver hResolver) {
            super(similarity);
            this.contextHitsCalculated = false;
            this.ancestorDocs = new int[2];
            this.pDocs = new int[1];
            this.singleDoc = new int[1];
            this.currentDoc = -1;
            this.hResolver = hResolver;
            this.contextHits = new BitSet(reader.maxDoc());
        }

        public int nextDoc() throws IOException {
            if (this.currentDoc == Integer.MAX_VALUE) {
                return this.currentDoc;
            }
            this.collectContextHits();
            try {
                this.currentDoc = DescendantSelfAxisQuery.this.subScorer.nextDoc();
            }
            catch (UnsupportedOperationException e) {
                ScorerWrapper collector = new ScorerWrapper(DescendantSelfAxisQuery.this.subScorer.getSimilarity());
                DescendantSelfAxisQuery.this.subScorer.score(collector.getCollector());
                DescendantSelfAxisQuery.this.subScorer = collector;
                this.currentDoc = DescendantSelfAxisQuery.this.subScorer.nextDoc();
            }
            if (this.contextHits.isEmpty()) {
                this.currentDoc = Integer.MAX_VALUE;
            }
            while (this.currentDoc != Integer.MAX_VALUE) {
                if (this.isValid(this.currentDoc)) {
                    return this.currentDoc;
                }
                this.currentDoc = DescendantSelfAxisQuery.this.subScorer.nextDoc();
            }
            return this.currentDoc;
        }

        public int docID() {
            return this.currentDoc;
        }

        public float score() throws IOException {
            return DescendantSelfAxisQuery.this.subScorer.score();
        }

        public int advance(int target) throws IOException {
            if (this.currentDoc == Integer.MAX_VALUE) {
                return this.currentDoc;
            }
            this.currentDoc = DescendantSelfAxisQuery.this.subScorer.nextDoc();
            if (this.currentDoc == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            this.collectContextHits();
            return this.isValid(this.currentDoc) ? this.currentDoc : this.nextDoc();
        }

        private void collectContextHits() throws IOException {
            if (!this.contextHitsCalculated) {
                long time = System.currentTimeMillis();
                DescendantSelfAxisQuery.this.contextScorer.score((Collector)new AbstractHitCollector(){

                    @Override
                    protected void collect(int doc, float score) {
                        DescendantSelfAxisScorer.this.contextHits.set(doc);
                    }
                });
                this.contextHitsCalculated = true;
                time = System.currentTimeMillis() - time;
                if (log.isDebugEnabled()) {
                    log.debug("Collected {} context hits in {} ms for {}", new Object[]{this.contextHits.cardinality(), time, DescendantSelfAxisQuery.this});
                }
            }
        }

        private boolean isValid(int doc) throws IOException {
            int pDoci;
            if (DescendantSelfAxisQuery.this.minLevels == 0 && this.contextHits.get(doc)) {
                return true;
            }
            this.pDocs = this.hResolver.getParents(doc, this.pDocs);
            if (this.pDocs.length == 0 || this.pDocs[0] < 0) {
                return false;
            }
            int ancestorCount = 0;
            this.ancestorDocs[ancestorCount++] = this.pDocs[0];
            while (!(this.pDocs.length == 0 || (pDoci = this.pDocs[0]) >= 0 && pDoci <= this.contextHits.size() && ancestorCount >= DescendantSelfAxisQuery.this.minLevels && this.contextHits.get(pDoci))) {
                this.pDocs = this.getParents(this.pDocs, this.singleDoc);
                if (this.pDocs.length == 0 || this.pDocs[0] < 0) {
                    return false;
                }
                if (ancestorCount == this.ancestorDocs.length) {
                    int[] copy = new int[this.ancestorDocs.length * 2];
                    System.arraycopy(this.ancestorDocs, 0, copy, 0, this.ancestorDocs.length);
                    this.ancestorDocs = copy;
                }
                if (this.pDocs.length == 0) continue;
                this.ancestorDocs[ancestorCount++] = this.pDocs[0];
            }
            if (this.pDocs.length > 0) {
                for (int i = 0; i < ancestorCount; ++i) {
                    this.contextHits.set(this.ancestorDocs[i]);
                }
                return true;
            }
            return false;
        }

        private int[] getParents(int[] docs, int[] pDocs) throws IOException {
            if (docs.length == 1) {
                return this.hResolver.getParents(docs[0], pDocs);
            }
            pDocs = new int[]{};
            for (int doc : docs) {
                int[] p = this.hResolver.getParents(doc, new int[0]);
                int[] tmp = new int[p.length + pDocs.length];
                System.arraycopy(pDocs, 0, tmp, 0, pDocs.length);
                System.arraycopy(p, 0, tmp, pDocs.length, p.length);
                pDocs = tmp;
            }
            return pDocs;
        }
    }

    private class DescendantSelfAxisWeight
    extends Weight {
        private static final long serialVersionUID = 8607634068040635882L;
        private final Searcher searcher;

        private DescendantSelfAxisWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return DescendantSelfAxisQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            DescendantSelfAxisQuery.this.contextScorer = DescendantSelfAxisQuery.this.contextQuery.weight(this.searcher).scorer(reader, scoreDocsInOrder, topScorer);
            DescendantSelfAxisQuery.this.subScorer = DescendantSelfAxisQuery.this.subQuery.weight(this.searcher).scorer(reader, scoreDocsInOrder, topScorer);
            if (DescendantSelfAxisQuery.this.subScorer == null) {
                return null;
            }
            HierarchyResolver resolver = (HierarchyResolver)reader;
            return new DescendantSelfAxisScorer(this.searcher.getSimilarity(), reader, resolver);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

