/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractWeight;
import org.exoplatform.services.jcr.impl.core.query.lucene.MatchAllScorer;

class MatchAllWeight
extends AbstractWeight {
    private static final long serialVersionUID = 3728644743899151526L;
    private final String field;
    private final Query query;
    private float value;
    private float idf;
    private float queryWeight;

    MatchAllWeight(Query query, Searcher searcher, String field) {
        super(searcher);
        this.query = query;
        this.field = field;
    }

    @Override
    protected Scorer createScorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
        return new MatchAllScorer(reader, this.field);
    }

    public Query getQuery() {
        return this.query;
    }

    public float getValue() {
        return this.value;
    }

    public float sumOfSquaredWeights() throws IOException {
        this.idf = this.searcher.getSimilarity().idf(this.searcher.maxDoc(), this.searcher.maxDoc());
        this.queryWeight = this.idf * 1.0f;
        return this.queryWeight * this.queryWeight;
    }

    public void normalize(float queryNorm) {
        this.queryWeight *= queryNorm;
        this.value = this.queryWeight * this.idf;
    }

    public Explanation explain(IndexReader reader, int doc) throws IOException {
        return new Explanation(Similarity.getDefault().idf(reader.maxDoc(), reader.maxDoc()), "matchAll");
    }
}

