/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.query.lucene.VirtualTableResolver;

public abstract class NodeTypeVirtualTableResolver<Q>
implements VirtualTableResolver<Q> {
    private final NodeTypeDataManager nodeTypeDataManager;

    public NodeTypeVirtualTableResolver(NodeTypeDataManager nodeTypeDataManager) {
        this.nodeTypeDataManager = nodeTypeDataManager;
    }

    protected Set<InternalQName> getSubTypes(InternalQName nodeTypeName) throws RepositoryException {
        return this.nodeTypeDataManager.getSubtypes(nodeTypeName);
    }

    protected boolean isMixin(InternalQName nodeTypeName) throws RepositoryException {
        NodeTypeData nodeType = this.nodeTypeDataManager.getNodeType(nodeTypeName);
        if (nodeType == null) {
            throw new NoSuchNodeTypeException("Node type " + nodeTypeName.getAsString() + " not found");
        }
        return nodeType.isMixin();
    }
}

