/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login.recovery;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.login.recovery.ChangePasswordConnector;
import org.exoplatform.web.security.security.CookieTokenService;

public class DefaultChangePasswordConnector
extends ChangePasswordConnector {
    private OrganizationService organizationService;
    private CookieTokenService cookieTokenService;
    public static final String LOG_SERVICE_NAME = "changePassword";
    protected static Log log = ExoLogger.getLogger(DefaultChangePasswordConnector.class);

    public DefaultChangePasswordConnector(InitParams initParams, OrganizationService organizationService, CookieTokenService cookieTokenService) {
        this.organizationService = organizationService;
        this.cookieTokenService = cookieTokenService;
    }

    public boolean isAllowChangeExternalPassword() {
        return false;
    }

    public void changePassword(String username, String password) throws Exception {
        User user = this.organizationService.getUserHandler().findUserByName(username);
        if (!user.isInternalStore()) {
            throw new Exception("Change password in external store in not allowed");
        }
        this.changeInternalPassword(user, password);
    }

    private void changeInternalPassword(User user, String password) throws Exception {
        long startTime = System.currentTimeMillis();
        user.setPassword(password);
        this.organizationService.getUserHandler().saveUser(user, true);
        this.cookieTokenService.deleteTokensByUsernameAndType(user.getUserName(), "");
        long totalTime = System.currentTimeMillis() - startTime;
        log.info("service={} operation={} parameters=\"user:{}\" status=ok duration_ms={}", new Object[]{LOG_SERVICE_NAME, "changeInternalPassword", user.getUserName(), totalTime});
    }
}

