/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.spi.DefinitionByType;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.StateKey;

@DefinitionByType
public final class ConversationRegistry {
    public static final String INIT_PARAM_CONCURRENCY_LEVEL = "concurrency-level";
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.security.core.ConversationRegistry");
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private final ConcurrentHashMap<StateKey, ConversationState> states;
    private final IdentityRegistry identityRegistry;
    private final ListenerService listenerService;

    public ConversationRegistry(InitParams params, IdentityRegistry identityRegistry, ListenerService listenerService) {
        this(ConversationRegistry.parse(params), identityRegistry, listenerService);
    }

    private static int parse(InitParams ip) {
        try {
            ValueParam concurrencyLevel;
            if (ip != null && (concurrencyLevel = ip.getValueParam(INIT_PARAM_CONCURRENCY_LEVEL)) != null) {
                return Integer.valueOf(concurrencyLevel.getValue());
            }
            return 16;
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"Can't parse parameter concurrency-level", (Throwable)e);
            return 16;
        }
    }

    private ConversationRegistry(int concurrencyLevel, IdentityRegistry identityRegistry, ListenerService listenerService) {
        this.states = new ConcurrentHashMap(concurrencyLevel, 0.75f, concurrencyLevel);
        this.identityRegistry = identityRegistry;
        this.listenerService = listenerService;
    }

    public ConversationState getState(StateKey key) {
        return this.states.get(key);
    }

    public void register(StateKey key, ConversationState state) {
        String userId = state.getIdentity().getUserId();
        boolean broadcast = this.states.get(key) == null && StringUtils.isNotBlank((String)userId) && this.getStateKeys(userId).isEmpty();
        this.states.put(key, state);
        if (broadcast) {
            try {
                this.listenerService.broadcast("exo.core.security.ConversationRegistry.register", (Object)this, (Object)state);
            }
            catch (Exception e) {
                LOG.error((Object)"Broadcast message filed ", (Throwable)e);
            }
        }
    }

    public ConversationState unregister(StateKey key) {
        return this.unregister(key, true);
    }

    public ConversationState unregister(StateKey key, boolean unregisterIdentity) {
        ConversationState state = this.states.remove(key);
        if (state == null) {
            return null;
        }
        String userId = state.getIdentity().getUserId();
        List<StateKey> keys = this.getStateKeys(userId);
        if (unregisterIdentity && keys.size() == 0) {
            this.identityRegistry.unregister(userId);
        }
        try {
            this.listenerService.broadcast("exo.core.security.ConversationRegistry.unregister", (Object)this, (Object)state);
        }
        catch (Exception e) {
            LOG.error((Object)"Broadcast message filed ", (Throwable)e);
        }
        return state;
    }

    public List<ConversationState> unregisterByUserId(String userId) {
        ArrayList<ConversationState> states = new ArrayList<ConversationState>();
        for (StateKey key : this.getStateKeys(userId)) {
            ConversationState state = this.unregister(key, false);
            if (state == null) continue;
            states.add(state);
        }
        return states;
    }

    public List<StateKey> getStateKeys(String userId) {
        ArrayList<StateKey> s = new ArrayList<StateKey>();
        for (Map.Entry<StateKey, ConversationState> a : this.states.entrySet()) {
            if (!a.getValue().getIdentity().getUserId().equals(userId)) continue;
            s.add(a.getKey());
        }
        return s;
    }

    void clear() {
        this.states.clear();
    }
}

