/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search.listener;

import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class SpaceESListenerImpl
extends SpaceListenerPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(SpaceESListenerImpl.class);

    public void spaceCreated(SpaceLifeCycleEvent event) {
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        String id = event.getSpace().getId();
        LOG.info("Notifying indexing service for space creation id={}", new Object[]{id});
        indexingService.index("space", id);
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
        this.reindex(event, "space description");
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        String id = event.getSpace().getId();
        LOG.debug("Notifying indexing service for space removal id={}", new Object[]{id});
        indexingService.unindex("space", id);
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
        this.reindex(event, "space renaming");
    }

    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
        this.reindex(event, "space access edited");
    }

    public void spaceRegistrationEdited(SpaceLifeCycleEvent event) {
        this.reindex(event, "space registration edited");
    }

    public void spaceBannerEdited(SpaceLifeCycleEvent event) {
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
        this.reindex(event, "space application activated");
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
        this.reindex(event, "space application added");
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
        this.reindex(event, "space application disabled");
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
        this.reindex(event, "space application removed");
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
        this.reindex(event, "space member granted as manager");
    }

    public void joined(SpaceLifeCycleEvent event) {
        this.reindex(event, "space member joined");
    }

    public void left(SpaceLifeCycleEvent event) {
        this.reindex(event, "space member left");
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
        this.reindex(event, "space member revoked as manager");
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
        this.reindex(event, "space avatar updated");
    }

    public void addInvitedUser(SpaceLifeCycleEvent event) {
        this.reindex(event, "user invited to space");
    }

    public void addPendingUser(SpaceLifeCycleEvent event) {
        this.reindex(event, "user requested access to space");
    }

    private void reindex(SpaceLifeCycleEvent event, String cause) {
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        String id = event.getSpace().getId();
        LOG.debug("Notifying indexing service for {} id={}", new Object[]{cause, id});
        indexingService.reindex("space", id);
    }
}

