/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletSecurityException;
import javax.portlet.PreferencesValidator;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.UnavailableException;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.common.concurrent.Valve;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.EventInvocation;
import org.gatein.pc.api.invocation.InvocationException;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.SecurityErrorResponse;
import org.gatein.pc.api.invocation.response.UnavailableResponse;
import org.gatein.pc.portlet.container.PortletApplication;
import org.gatein.pc.portlet.container.PortletContainerContext;
import org.gatein.pc.portlet.container.PortletFilter;
import org.gatein.pc.portlet.container.PortletInitializationException;
import org.gatein.pc.portlet.container.managed.LifeCycleStatus;
import org.gatein.pc.portlet.container.object.PortletContainerObject;
import org.gatein.pc.portlet.impl.info.ContainerPortletInfo;
import org.gatein.pc.portlet.impl.info.ContainerPreferencesInfo;
import org.gatein.pc.portlet.impl.info.ResourceBundleManager;
import org.gatein.pc.portlet.impl.jsr168.PortletApplicationImpl;
import org.gatein.pc.portlet.impl.jsr168.PortletFilterImpl;
import org.gatein.pc.portlet.impl.jsr168.PortletResourceBundleFactory;
import org.gatein.pc.portlet.impl.jsr168.api.ActionRequestImpl;
import org.gatein.pc.portlet.impl.jsr168.api.ActionResponseImpl;
import org.gatein.pc.portlet.impl.jsr168.api.EventRequestImpl;
import org.gatein.pc.portlet.impl.jsr168.api.EventResponseImpl;
import org.gatein.pc.portlet.impl.jsr168.api.FilterChainImpl;
import org.gatein.pc.portlet.impl.jsr168.api.PortletConfigImpl;
import org.gatein.pc.portlet.impl.jsr168.api.PortletRequestImpl;
import org.gatein.pc.portlet.impl.jsr168.api.PortletResponseImpl;
import org.gatein.pc.portlet.impl.jsr168.api.RenderRequestImpl;
import org.gatein.pc.portlet.impl.jsr168.api.RenderResponseImpl;
import org.gatein.pc.portlet.impl.jsr168.api.ResourceRequestImpl;
import org.gatein.pc.portlet.impl.jsr168.api.ResourceResponseImpl;

public class PortletContainerImpl
implements PortletContainerObject {
    protected final Log log;
    final ContainerPortletInfo info;
    protected PortletApplicationImpl application;
    protected String className;
    protected PortletConfig config;
    protected Portlet portlet;
    protected final Valve valve;
    protected LifeCycleStatus status;
    protected Set userDataConstraints;
    private final Invoker invoker = new Invoker();
    private List<ActionFilter> actionFilterList;
    private List<EventFilter> eventFilterList;
    private List<RenderFilter> renderFilterList;
    private List<ResourceFilter> resourceFilterList;
    private PortletContainerContext context;
    private Set<PortletFilterImpl> filters;
    protected PreferencesValidator preferencesValidator;

    public PortletContainerImpl(ContainerPortletInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("No null info is accepted");
        }
        this.info = info;
        this.valve = new Valve();
        this.log = ExoLogger.getLogger((String)("org.gatein.pc.container." + info.getClassName().replace('.', '_')));
        this.status = LifeCycleStatus.INITIALIZED;
        this.filters = new HashSet<PortletFilterImpl>();
    }

    @Override
    public void setContext(PortletContainerContext context) {
        this.context = context;
    }

    @Override
    public PortletContainerContext getContext() {
        return this.context;
    }

    @Override
    public ContainerPortletInfo getInfo() {
        if (this.status == LifeCycleStatus.STARTED) {
            return this.info;
        }
        throw new IllegalStateException("Portlet " + this.info.getName() + " is not started");
    }

    @Override
    public Portlet getPortletInstance() {
        return this.portlet;
    }

    @Override
    public String getId() {
        return this.info.getName();
    }

    @Override
    public void addPortletFilter(PortletFilter filter) {
        this.filters.add((PortletFilterImpl)filter);
    }

    @Override
    public void removePortletFilter(PortletFilter filter) {
        this.filters.remove((PortletFilterImpl)filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() throws Exception {
        block12: {
            String validatorClassName;
            this.className = this.info.getClassName();
            ContainerPreferencesInfo preferences = this.info.getPreferences();
            if (preferences != null && (validatorClassName = preferences.getValidatorClassName()) != null) {
                try {
                    if (validatorClassName == null) break block12;
                    ClassLoader loader = this.application.getContext().getClassLoader();
                    ClassLoader old = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(loader);
                        Class<?> preferencesValidatorClass = loader.loadClass(validatorClassName);
                        this.preferencesValidator = (PreferencesValidator)preferencesValidatorClass.newInstance();
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(old);
                    }
                }
                catch (ClassNotFoundException e) {
                    this.log.error((Object)"Class for preference validator not found", (Throwable)e);
                }
                catch (InstantiationException e) {
                    this.log.error((Object)"Cannot instantiate preference validator", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new Error();
                }
            }
        }
        ResourceBundleManager bundleManager = PortletResourceBundleFactory.createResourceBundleManager(this.info.getBundleManager(), this.info);
        PortletConfigImpl config = new PortletConfigImpl(this.info, this.application.info, this.application.portletContext, bundleManager);
        try {
            Portlet portlet;
            Class<?> portletClass = this.application.getContext().getClassLoader().loadClass(this.className);
            this.portlet = portlet = (Portlet)portletClass.newInstance();
            this.config = config;
            this.status = LifeCycleStatus.CREATED;
        }
        catch (IllegalAccessException e) {
            throw new PortletInitializationException("Portlet class not accessible " + this.className, e);
        }
        catch (ClassNotFoundException e) {
            throw new PortletInitializationException("Portlet class not found " + this.className, e);
        }
        catch (InstantiationException e) {
            throw new PortletInitializationException("Portlet class cannot be instantiated " + this.className, e);
        }
    }

    @Override
    public void start() throws Exception {
        try {
            this.initPortlet(this.portlet, this.config);
            this.buildFilterChains();
            this.valve.open();
            this.status = LifeCycleStatus.STARTED;
        }
        catch (PortletException e) {
            throw new PortletInitializationException("The portlet " + this.getId() + " threw a portlet exception during init", e);
        }
        catch (RuntimeException e) {
            throw new PortletInitializationException("The portlet " + this.getId() + " threw a runtime exception during init", e);
        }
        catch (Error e) {
            throw new PortletInitializationException("The portlet " + this.getId() + " threw an error during init", e);
        }
    }

    private void buildFilterChains() {
        List<ActionFilter> actionFilterList = this.builderFilterList(ActionFilter.class);
        List<EventFilter> eventFilterList = this.builderFilterList(EventFilter.class);
        List<RenderFilter> renderFilterList = this.builderFilterList(RenderFilter.class);
        List<ResourceFilter> resourceFilterList = this.builderFilterList(ResourceFilter.class);
        actionFilterList.add(this.invoker);
        eventFilterList.add(this.invoker);
        renderFilterList.add(this.invoker);
        resourceFilterList.add(this.invoker);
        this.actionFilterList = Collections.unmodifiableList(actionFilterList);
        this.eventFilterList = Collections.unmodifiableList(eventFilterList);
        this.renderFilterList = Collections.unmodifiableList(renderFilterList);
        this.resourceFilterList = Collections.unmodifiableList(resourceFilterList);
    }

    private <T extends javax.portlet.filter.PortletFilter> List<T> builderFilterList(Class<T> type) {
        ArrayList<javax.portlet.filter.PortletFilter> list = new ArrayList<javax.portlet.filter.PortletFilter>();
        for (String filterRef : this.info.getFilterRefs()) {
            for (PortletFilterImpl filter : this.filters) {
                javax.portlet.filter.PortletFilter filterInstance;
                if (!filter.getId().equals(filterRef) || (filterInstance = (javax.portlet.filter.PortletFilter)filter.instance(type)) == null) continue;
                list.add(filterInstance);
            }
        }
        return list;
    }

    @Override
    public void stop() {
        this.log.debug((Object)"Trying to close the valve");
        boolean done = this.valve.closing(60000L);
        if (!done) {
            this.log.warn((Object)"The valve is still holding invocations, continue anyway");
        }
        this.valve.closed();
        this.status = LifeCycleStatus.CREATED;
        this.destroyPortlet(this.portlet);
    }

    @Override
    public void destroy() {
        this.preferencesValidator = null;
        this.className = null;
        this.portlet = null;
        this.config = null;
        this.userDataConstraints = null;
        this.status = LifeCycleStatus.INITIALIZED;
    }

    public PortletConfig getConfig() {
        return this.config;
    }

    public Portlet getPortlet() {
        return this.portlet;
    }

    @Override
    public PortletApplication getPortletApplication() {
        return this.application;
    }

    @Override
    public void setPortletApplication(PortletApplication application) {
        this.application = (PortletApplicationImpl)application;
    }

    public Valve getValve() {
        return this.valve;
    }

    public Set getUserDataConstraints() {
        return this.userDataConstraints;
    }

    public PreferencesValidator getPreferencesValidator() {
        return this.preferencesValidator;
    }

    public String toString() {
        return "PortletContainer[name=" + this.getId() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPortlet(Portlet portlet, PortletConfig config) throws PortletException {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader newLoader = this.application.getContext().getClassLoader();
            Thread.currentThread().setContextClassLoader(newLoader);
            portlet.init(config);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyPortlet(Portlet portlet) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader newLoader = this.application.getContext().getClassLoader();
            Thread.currentThread().setContextClassLoader(newLoader);
            if (portlet != null) {
                portlet.destroy();
            } else {
                this.log.debug((Object)"Cannot call destroy, portlet was null");
            }
        }
        catch (RuntimeException e) {
            this.log.error((Object)"The portlet threw a runtime exception", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortletInvocationResponse dispatch(PortletInvocation invocation) throws PortletInvokerException, InvocationException {
        FilterChainImpl<ActionFilter> chain;
        String phase;
        PortletResponseImpl resp;
        PortletRequestImpl req;
        HttpServletRequest dreq = invocation.getRequest();
        if (invocation instanceof ActionInvocation) {
            req = new ActionRequestImpl(this, (ActionInvocation)invocation);
            resp = new ActionResponseImpl((ActionInvocation)invocation, req);
            phase = "ACTION_PHASE";
            chain = new FilterChainImpl<ActionFilter>(this.actionFilterList, ActionFilter.class);
        } else if (invocation instanceof RenderInvocation) {
            req = new RenderRequestImpl(this, (RenderInvocation)invocation);
            resp = new RenderResponseImpl((RenderInvocation)invocation, req);
            phase = "RENDER_PHASE";
            chain = new FilterChainImpl<RenderFilter>(this.renderFilterList, RenderFilter.class);
        } else if (invocation instanceof EventInvocation) {
            req = new EventRequestImpl(this, (EventInvocation)invocation);
            resp = new EventResponseImpl((EventInvocation)invocation, req);
            phase = "EVENT_PHASE";
            chain = new FilterChainImpl<EventFilter>(this.eventFilterList, EventFilter.class);
        } else if (invocation instanceof ResourceInvocation) {
            req = new ResourceRequestImpl(this, (ResourceInvocation)invocation);
            resp = new ResourceResponseImpl((ResourceInvocation)invocation, req);
            phase = "RESOURCE_PHASE";
            chain = new FilterChainImpl<ResourceFilter>(this.resourceFilterList, ResourceFilter.class);
        } else {
            throw new InvocationException("Unexpected invocation " + invocation);
        }
        try {
            dreq.setAttribute("org.jboss.portal.attribute.component_invocation", (Object)invocation);
            dreq.setAttribute("javax.portlet.config", (Object)this.config);
            dreq.setAttribute("javax.portlet.request", (Object)req);
            dreq.setAttribute("javax.portlet.response", (Object)resp);
            dreq.setAttribute("javax.portlet.lifecycle_phase", (Object)phase);
            chain.doFilter(req, resp);
            PortletInvocationResponse portletInvocationResponse = resp.getResponse();
            return portletInvocationResponse;
        }
        catch (NoClassDefFoundError e) {
            ErrorResponse errorResponse = new ErrorResponse((Throwable)e);
            return errorResponse;
        }
        catch (Exception e) {
            this.log.error((Object)"The portlet threw an exception", (Throwable)e);
            if (e instanceof PortletSecurityException) {
                SecurityErrorResponse securityErrorResponse = new SecurityErrorResponse((Throwable)e);
                return securityErrorResponse;
            }
            if (e instanceof UnavailableException) {
                UnavailableException ue = (UnavailableException)e;
                if (ue.isPermanent()) {
                    UnavailableResponse unavailableResponse = new UnavailableResponse();
                    return unavailableResponse;
                }
                UnavailableResponse unavailableResponse = new UnavailableResponse(ue.getUnavailableSeconds());
                return unavailableResponse;
            }
            ErrorResponse errorResponse = new ErrorResponse((Throwable)e);
            return errorResponse;
        }
        finally {
            dreq.removeAttribute("org.jboss.portal.attribute.component_invocation");
            dreq.removeAttribute("javax.portlet.config");
            dreq.removeAttribute("javax.portlet.request");
            dreq.removeAttribute("javax.portlet.response");
            dreq.removeAttribute("javax.portlet.lifecycle_phase");
        }
    }

    private class Invoker
    implements ActionFilter,
    EventFilter,
    RenderFilter,
    ResourceFilter {
        private Invoker() {
        }

        public void doFilter(ActionRequest req, ActionResponse resp, FilterChain chain) throws IOException, PortletException {
            PortletContainerImpl.this.portlet.processAction(req, resp);
        }

        public void doFilter(EventRequest req, EventResponse resp, FilterChain chain) throws IOException, PortletException {
            EventPortlet eventPortlet = (EventPortlet)PortletContainerImpl.this.portlet;
            eventPortlet.processEvent(req, resp);
        }

        public void doFilter(RenderRequest req, RenderResponse resp, FilterChain chain) throws IOException, PortletException {
            PortletContainerImpl.this.portlet.render(req, resp);
        }

        public void doFilter(ResourceRequest req, ResourceResponse resp, FilterChain chain) throws IOException, PortletException {
            ResourceServingPortlet servingPortlet = (ResourceServingPortlet)PortletContainerImpl.this.portlet;
            servingPortlet.serveResource(req, resp);
        }

        public void init(FilterConfig filterConfig) throws PortletException {
        }

        public void destroy() {
        }
    }
}

