/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public abstract class DocumentSource {
    private String identifier;

    private DocumentSource(String identifier) {
        if (identifier == null) {
            throw new NullPointerException("An identifier must be provided");
        }
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public abstract InputStream getStream() throws IOException;

    public static DocumentSource create(String identifier, final InputStream in) {
        return new DocumentSource(identifier){

            @Override
            public InputStream getStream() throws IOException {
                return in;
            }
        };
    }

    public static DocumentSource create(final URL url) {
        return new DocumentSource(url.toString()){

            @Override
            public InputStream getStream() throws IOException {
                return url.openStream();
            }
        };
    }
}

