/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.notification.builder;

import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import java.io.Writer;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.agenda.model.AgendaUserSettings;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.agenda.service.AgendaUserSettingsService;
import org.exoplatform.agenda.util.NotificationUtils;
import org.exoplatform.agenda.util.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;

public class ReplyTemplateBuilder
extends AbstractTemplateBuilder {
    private static final Log LOG = ExoLogger.getLogger(ReplyTemplateBuilder.class);
    private AgendaEventService agendaEventService;
    private AgendaUserSettingsService agendaUserSettingsService;
    private IdentityManager identityManager;
    private TemplateProvider templateProvider;
    private ExoContainer container;
    private boolean isPushNotification;
    private PluginKey key;

    public ReplyTemplateBuilder(TemplateProvider templateProvider, ExoContainer container, PluginKey key, boolean isPushNotification) {
        this.templateProvider = templateProvider;
        this.container = container;
        this.key = key;
        this.isPushNotification = isPushNotification;
    }

    public Template getTemplateEngine() {
        String templatePath = null;
        try {
            templatePath = (String)this.templateProvider.getTemplateFilePathConfigs().get(this.key);
            String template = TemplateUtils.loadGroovyTemplate((String)templatePath);
            if (StringUtils.isBlank((String)template)) {
                throw new IllegalStateException("Template with path " + templatePath + " wasn't found");
            }
            return new GStringTemplateEngine().createTemplate(template);
        }
        catch (Exception e) {
            LOG.warn("Error while compiling template {}", new Object[]{templatePath, e});
            try {
                return new GStringTemplateEngine().createTemplate("");
            }
            catch (Exception e1) {
                LOG.warn((Object)"Error while creating empty template", (Throwable)e1);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageInfo makeMessage(NotificationContext ctx) {
        NotificationInfo notification = ctx.getNotificationInfo();
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            Event event = this.getEvent(notification);
            if (event == null) {
                MessageInfo messageInfo = null;
                return messageInfo;
            }
            String notificationURL = notification.getValueOwnerParameter("Url");
            if (StringUtils.isBlank((String)notificationURL)) {
                notificationURL = NotificationUtils.getEventURL(event);
            }
            String pushNotificationURL = this.isPushNotification ? notificationURL : null;
            String username = notification.getTo();
            long identityId = Utils.getIdentityIdByUsername(this.getIdentityManager(), username);
            boolean isCreator = event.getCreatorId() == identityId;
            AgendaUserSettings agendaUserSettings = this.getAgendaUserSettingsService().getAgendaUserSettings(identityId);
            ZoneOffset timeZone = agendaUserSettings == null || agendaUserSettings.getTimeZoneId() == null ? ZoneOffset.UTC : ZoneId.of(agendaUserSettings.getTimeZoneId());
            TemplateContext templateContext = NotificationUtils.buildTemplateReplyParameters(this.templateProvider, notification, timeZone, isCreator);
            MessageInfo messageInfo = NotificationUtils.buildMessageSubjectAndBody(templateContext, notification, pushNotificationURL);
            Throwable exception = templateContext.getException();
            this.logException(notification, exception);
            ctx.setException(exception);
            MessageInfo messageInfo2 = messageInfo;
            return messageInfo2;
        }
        catch (Throwable e) {
            ctx.setException(e);
            this.logException(notification, e);
            MessageInfo messageInfo = null;
            return messageInfo;
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    protected boolean makeDigest(NotificationContext notificationContext, Writer writer) {
        return false;
    }

    public TemplateProvider getTemplateProvider() {
        return this.templateProvider;
    }

    private final Event getEvent(NotificationInfo notification) {
        String eventIdString = notification.getValueOwnerParameter("eventId");
        if (StringUtils.isBlank((String)eventIdString)) {
            throw new IllegalStateException("Event id is missing in notification");
        }
        long eventId = Long.parseLong(eventIdString);
        if (eventId == 0L) {
            throw new IllegalStateException("Event id is equal to 0 in notification");
        }
        return this.getEventService().getEventById(eventId);
    }

    private void logException(NotificationInfo notification, Throwable e) {
        if (e != null) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Error building notification content: {}", new Object[]{notification, e});
            } else {
                LOG.warn("Error building notification content: {}, error: {}", new Object[]{notification, e.getMessage()});
            }
        }
    }

    private AgendaEventService getEventService() {
        if (this.agendaEventService == null) {
            this.agendaEventService = (AgendaEventService)CommonsUtils.getService(AgendaEventService.class);
        }
        return this.agendaEventService;
    }

    private AgendaUserSettingsService getAgendaUserSettingsService() {
        if (this.agendaUserSettingsService == null) {
            this.agendaUserSettingsService = (AgendaUserSettingsService)this.container.getComponentInstanceOfType(AgendaUserSettingsService.class);
        }
        return this.agendaUserSettingsService;
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)this.container.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }
}

