/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.CharacteristicTypeMap;
import org.apache.sis.feature.FieldType;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;

public class DefaultAttributeType<V>
extends FieldType {
    private static final long serialVersionUID = -817024213677735239L;
    private final Class<V> valueClass;
    private final V defaultValue;
    private transient CharacteristicTypeMap characteristics;

    public DefaultAttributeType(Map<String, ?> map, Class<V> clazz, int n, int n2, V v, DefaultAttributeType<?> ... defaultAttributeTypeArray) {
        super(map, n, n2);
        ArgumentChecks.ensureNonNull((String)"valueClass", clazz);
        ArgumentChecks.ensureCanCast((String)"defaultValue", clazz, v);
        this.valueClass = clazz;
        this.defaultValue = Numerics.cached(v);
        if (defaultAttributeTypeArray != null && defaultAttributeTypeArray.length != 0) {
            this.characteristics = CharacteristicTypeMap.create(this, (DefaultAttributeType[])defaultAttributeTypeArray.clone());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.characteristics != null ? this.characteristics.characterizedBy : null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            DefaultAttributeType[] defaultAttributeTypeArray = (DefaultAttributeType[])objectInputStream.readObject();
            if (defaultAttributeTypeArray != null) {
                this.characteristics = CharacteristicTypeMap.create(this, defaultAttributeTypeArray);
            }
        }
        catch (RuntimeException runtimeException) {
            throw (IOException)new InvalidObjectException(runtimeException.getLocalizedMessage()).initCause(runtimeException);
        }
    }

    public final Class<V> getValueClass() {
        return this.valueClass;
    }

    @Override
    public final int getMinimumOccurs() {
        return super.getMinimumOccurs();
    }

    @Override
    public final int getMaximumOccurs() {
        return super.getMaximumOccurs();
    }

    public V getDefaultValue() {
        return this.defaultValue;
    }

    public Map<String, DefaultAttributeType<?>> characteristics() {
        return this.characteristics != null ? this.characteristics : Collections.emptyMap();
    }

    public AbstractAttribute<V> newInstance() {
        return AbstractAttribute.create(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.valueClass.hashCode() + Objects.hashCode(this.defaultValue) + Objects.hashCode((Object)this.characteristics);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            DefaultAttributeType defaultAttributeType = (DefaultAttributeType)object;
            return this.valueClass == defaultAttributeType.valueClass && Objects.equals(this.defaultValue, defaultAttributeType.defaultValue) && Objects.equals((Object)this.characteristics, (Object)defaultAttributeType.characteristics);
        }
        return false;
    }

    public String toString() {
        return DefaultAttributeType.toString(this.deprecated, "AttributeType", this.getName(), Classes.getShortName(this.valueClass)).toString();
    }
}

