/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.util.Optional;
import org.apache.sis.image.DefaultIterator;
import org.apache.sis.image.SequenceType;
import org.apache.sis.internal.feature.Resources;

final class LinearIterator
extends DefaultIterator {
    LinearIterator(Raster raster, WritableRaster writableRaster, Rectangle rectangle, Dimension dimension) {
        super(raster, writableRaster, rectangle, dimension);
    }

    LinearIterator(RenderedImage renderedImage, WritableRenderedImage writableRenderedImage, Rectangle rectangle, Dimension dimension) {
        super(renderedImage, writableRenderedImage, rectangle, dimension);
    }

    @Override
    public Optional<SequenceType> getIterationOrder() {
        return Optional.of(SequenceType.LINEAR);
    }

    @Override
    public boolean next() {
        if (++this.x >= this.currentUpperX) {
            if (this.x < this.upperX) {
                this.close();
                ++this.tileX;
            } else {
                this.x = this.lowerX;
                if (++this.y >= this.currentUpperY) {
                    this.close();
                    if (++this.tileY >= this.tileUpperY) {
                        this.endOfIteration();
                        return false;
                    }
                } else if (this.tileX == this.tileLowerX) {
                    return true;
                }
                this.close();
                this.tileX = this.tileLowerX;
            }
            if (this.fetchTile() > this.y) {
                throw new RasterFormatException(Resources.format((short)35, this.tileX, this.tileY));
            }
        }
        return true;
    }
}

