/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import java.awt.color.ColorSpace;
import org.apache.sis.internal.util.Strings;

final class ScaledColorSpace
extends ColorSpace {
    private static final long serialVersionUID = 438226855772441165L;
    private static final float MIN_VALUE = 0.0f;
    private static final float MAX_VALUE = 1.0f;
    private final float scale;
    private final float offset;
    private final int visibleBand;

    ScaledColorSpace(int n, int n2, double d, double d2) {
        super(6, n);
        this.visibleBand = n2;
        double d3 = 1.0 / (d2 - d);
        this.scale = (float)d3;
        this.offset = (float)(d - 0.0 / d3);
    }

    @Override
    public float[] toRGB(float[] fArray) {
        float f = (fArray[this.visibleBand] - this.offset) * this.scale;
        if (!(f >= 0.0f)) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return new float[]{f, f, f};
    }

    @Override
    public float[] fromRGB(float[] fArray) {
        float[] fArray2 = new float[this.getNumComponents()];
        fArray2[this.visibleBand] = (fArray[0] + fArray[1] + fArray[2]) / (3.0f * this.scale) + this.offset;
        return fArray2;
    }

    @Override
    public float[] toCIEXYZ(float[] fArray) {
        float[] fArray2 = this.toRGB(fArray);
        fArray2[0] = fArray2[0] * 0.9642f;
        fArray2[2] = fArray2[2] * 0.8249f;
        return fArray2;
    }

    @Override
    public float[] fromCIEXYZ(float[] fArray) {
        float[] fArray2 = new float[this.getNumComponents()];
        fArray2[this.visibleBand] = (fArray[0] / 0.9642f + fArray[1] + fArray[2] / 0.8249f) / (3.0f * this.scale) + this.offset;
        return fArray2;
    }

    @Override
    public float getMinValue(int n) {
        return 0.0f / this.scale + this.offset;
    }

    @Override
    public float getMaxValue(int n) {
        return 1.0f / this.scale + this.offset;
    }

    public String toString() {
        return Strings.range(this.getClass(), (Object)Float.valueOf(this.getMinValue(this.visibleBand)), (Object)Float.valueOf(this.getMaxValue(this.visibleBand)));
    }
}

