/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.Arrays;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.wiki.WikiPortletPreference;
import org.exoplatform.wiki.webui.UIWikiNavigationContainer;
import org.exoplatform.wiki.webui.UIWikiPageContainer;
import org.exoplatform.wiki.webui.UIWikiPageSettingContainer;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiRelatedPages;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.core.UIWikiContainer;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiMiddleArea.gtmpl", events={@EventConfig(listeners={ShowHideActionListener.class})})
public class UIWikiMiddleArea
extends UIWikiContainer {
    public static String SHOW_HIDE_ACTION = "ShowHide";
    public static boolean SHOW_LEFT_PANEL_DEFAULT = true;

    public UIWikiMiddleArea() throws Exception {
        this.accept_Modes = Arrays.asList(WikiMode.VIEW, WikiMode.EDITPAGE, WikiMode.ADDPAGE, WikiMode.ADVANCEDSEARCH, WikiMode.SHOWHISTORY, WikiMode.PAGE_NOT_FOUND, WikiMode.VIEWREVISION, WikiMode.PAGEINFO, WikiMode.ADDTEMPLATE, WikiMode.EDITTEMPLATE, WikiMode.COMPAREREVISION, WikiMode.SPACESETTING, WikiMode.MYDRAFTS);
        this.addChild(UIWikiNavigationContainer.class, null, null);
        this.addChild(UIWikiPageContainer.class, null, null);
        this.addChild(UIWikiPageSettingContainer.class, null, null);
        this.addChild(UIWikiRelatedPages.class, null, null);
    }

    protected boolean isNavigationRender() {
        WikiPortletPreference preferences = ((UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class)).getPortletPreferences();
        UIWikiNavigationContainer navigation = (UIWikiNavigationContainer)this.getChild(UIWikiNavigationContainer.class);
        return navigation.getAccept_Modes().contains((Object)navigation.getCurrentMode()) && navigation.isRendered() && preferences.isShowNavigationTree();
    }

    protected boolean isPageSettingContainerRender() {
        UIWikiPageSettingContainer settingContainer = (UIWikiPageSettingContainer)this.getChild(UIWikiPageSettingContainer.class);
        return settingContainer.getAccept_Modes().contains((Object)settingContainer.getCurrentMode()) && settingContainer.isRendered();
    }

    public String getLeftPanelWidth() {
        HttpServletRequest req = Util.getPortalRequestContext().getRequest();
        Cookie[] cookies = req.getCookies();
        Object width = "";
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(req.getRemoteUser() + "_leftWidth")) continue;
                width = "width: " + cookie.getValue() + "px";
                break;
            }
        }
        return width;
    }

    public boolean isShowLeftPanel() {
        HttpServletRequest req = Util.getPortalRequestContext().getRequest();
        Cookie[] cookies = req.getCookies();
        boolean showLeftPanel = SHOW_LEFT_PANEL_DEFAULT;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(req.getRemoteUser() + "_ShowLeftContainer")) continue;
                showLeftPanel = Boolean.parseBoolean(cookie.getValue());
                break;
            }
        }
        return showLeftPanel;
    }

    public static class ShowHideActionListener
    extends EventListener<UIWikiMiddleArea> {
        public void execute(Event<UIWikiMiddleArea> event) throws Exception {
            UIWikiNavigationContainer navigation;
            UIWikiMiddleArea middleArea = (UIWikiMiddleArea)((Object)event.getSource());
            navigation.setRendered(!(navigation = (UIWikiNavigationContainer)middleArea.getChild(UIWikiNavigationContainer.class)).isRendered());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)middleArea);
        }
    }
}

