/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.alter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterExpression;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterOperation;

public class Alter
implements Statement {
    private Table table;
    private boolean useOnly = false;
    private List<AlterExpression> alterExpressions;

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public boolean isUseOnly() {
        return this.useOnly;
    }

    public void setUseOnly(boolean bl2) {
        this.useOnly = bl2;
    }

    public void addAlterExpression(AlterExpression alterExpression) {
        if (this.alterExpressions == null) {
            this.alterExpressions = new ArrayList<AlterExpression>();
        }
        this.alterExpressions.add(alterExpression);
    }

    public List<AlterExpression> getAlterExpressions() {
        return this.alterExpressions;
    }

    public void setAlterExpressions(List<AlterExpression> list) {
        this.alterExpressions = list;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ALTER TABLE ");
        if (this.useOnly) {
            stringBuilder.append("ONLY ");
        }
        if (this.alterExpressions.size() > 0 && this.alterExpressions.get(0).getOperation() == AlterOperation.RENAME_TABLE && this.alterExpressions.get(0).isUsingIfExists()) {
            stringBuilder.append("IF EXISTS ");
        }
        stringBuilder.append(this.table.getFullyQualifiedName()).append(" ");
        Iterator<AlterExpression> iterator = this.alterExpressions.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public Alter withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Alter withUseOnly(boolean bl2) {
        this.setUseOnly(bl2);
        return this;
    }

    public Alter withAlterExpressions(List<AlterExpression> list) {
        this.setAlterExpressions(list);
        return this;
    }

    public Alter addAlterExpressions(AlterExpression ... alterExpressionArray) {
        List list = Optional.ofNullable(this.getAlterExpressions()).orElseGet(ArrayList::new);
        Collections.addAll(list, alterExpressionArray);
        return this.withAlterExpressions(list);
    }

    public Alter addAlterExpressions(Collection<? extends AlterExpression> collection) {
        List list = Optional.ofNullable(this.getAlterExpressions()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withAlterExpressions(list);
    }
}

