/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Map;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.factory.NoSuchAuthorityFactoryException;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.Factory;
import org.opengis.util.FactoryException;

public class ReferencingFactoryContainer {
    public static final String MT_FACTORY = "mtFactory";
    public static final String CRS_FACTORY = "crsFactory";
    public static final String CS_FACTORY = "csFactory";
    public static final String DATUM_FACTORY = "datumFactory";
    private CRSAuthorityFactory crsAuthorityFactory;
    private DatumFactory datumFactory;
    private CSFactory csFactory;
    private CRSFactory crsFactory;
    private DefaultCoordinateOperationFactory operationFactory;
    private MathTransformFactory mtFactory;
    private Map<String, ?> defaultProperties;

    public ReferencingFactoryContainer() {
    }

    public ReferencingFactoryContainer(Map<String, ?> map, CRSFactory cRSFactory, CSFactory cSFactory, DatumFactory datumFactory, CoordinateOperationFactory coordinateOperationFactory, MathTransformFactory mathTransformFactory) {
        this.defaultProperties = map;
        this.crsFactory = cRSFactory;
        this.csFactory = cSFactory;
        this.datumFactory = datumFactory;
        this.operationFactory = (DefaultCoordinateOperationFactory)coordinateOperationFactory;
        this.mtFactory = mathTransformFactory;
    }

    public final <T extends Factory> boolean setFactory(Class<T> clazz, T t) {
        if (clazz == CRSFactory.class) {
            this.crsFactory = (CRSFactory)t;
            return this.crsFactory != this.crsFactory;
        }
        if (clazz == CSFactory.class) {
            this.csFactory = (CSFactory)t;
            return this.csFactory != this.csFactory;
        }
        if (clazz == DatumFactory.class) {
            this.datumFactory = (DatumFactory)t;
            return this.datumFactory != this.datumFactory;
        }
        if (clazz == CoordinateOperationFactory.class) {
            this.operationFactory = (DefaultCoordinateOperationFactory)t;
            return this.operationFactory != this.operationFactory;
        }
        if (clazz == MathTransformFactory.class) {
            this.mtFactory = (MathTransformFactory)t;
            return this.mtFactory != this.mtFactory;
        }
        throw new IllegalArgumentException(Errors.format((short)45, (Object)"type", clazz));
    }

    public final <T extends Factory> T getFactory(Class<T> clazz) {
        Object object;
        if (clazz == CRSFactory.class) {
            object = this.getCRSFactory();
        } else if (clazz == CSFactory.class) {
            object = this.getCSFactory();
        } else if (clazz == DatumFactory.class) {
            object = this.getDatumFactory();
        } else if (clazz == CoordinateOperationFactory.class) {
            object = this.getCoordinateOperationFactory();
        } else if (clazz == MathTransformFactory.class) {
            object = this.getMathTransformFactory();
        } else {
            throw new IllegalArgumentException(Errors.format((short)45, (Object)"type", clazz));
        }
        return (T)((Factory)clazz.cast(object));
    }

    public final CRSAuthorityFactory getCRSAuthorityFactory() throws FactoryException {
        if (this.crsAuthorityFactory == null) {
            this.crsAuthorityFactory = CRS.getAuthorityFactory("EPSG");
        }
        return this.crsAuthorityFactory;
    }

    public final CSAuthorityFactory getCSAuthorityFactory() throws FactoryException {
        CRSAuthorityFactory cRSAuthorityFactory = this.getCRSAuthorityFactory();
        if (cRSAuthorityFactory instanceof CSAuthorityFactory) {
            return (CSAuthorityFactory)cRSAuthorityFactory;
        }
        throw new NoSuchAuthorityFactoryException(null, "EPSG");
    }

    public final DatumAuthorityFactory getDatumAuthorityFactory() throws FactoryException {
        CRSAuthorityFactory cRSAuthorityFactory = this.getCRSAuthorityFactory();
        if (cRSAuthorityFactory instanceof DatumAuthorityFactory) {
            return (DatumAuthorityFactory)cRSAuthorityFactory;
        }
        throw new NoSuchAuthorityFactoryException(null, "EPSG");
    }

    public final CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory() throws FactoryException {
        CRSAuthorityFactory cRSAuthorityFactory = this.getCRSAuthorityFactory();
        if (cRSAuthorityFactory instanceof CoordinateOperationAuthorityFactory) {
            return (CoordinateOperationAuthorityFactory)cRSAuthorityFactory;
        }
        throw new NoSuchAuthorityFactoryException(null, "EPSG");
    }

    public final CRSFactory getCRSFactory() {
        if (this.crsFactory == null) {
            this.crsFactory = (CRSFactory)DefaultFactories.forBuildin(CRSFactory.class);
        }
        return this.crsFactory;
    }

    public final CSFactory getCSFactory() {
        if (this.csFactory == null) {
            this.csFactory = (CSFactory)DefaultFactories.forBuildin(CSFactory.class);
        }
        return this.csFactory;
    }

    public final DatumFactory getDatumFactory() {
        if (this.datumFactory == null) {
            this.datumFactory = (DatumFactory)DefaultFactories.forBuildin(DatumFactory.class);
        }
        return this.datumFactory;
    }

    public final DefaultCoordinateOperationFactory getCoordinateOperationFactory() {
        if (this.operationFactory == null) {
            CoordinateOperationFactory coordinateOperationFactory = CoordinateOperations.getCoordinateOperationFactory(this.defaultProperties, this.mtFactory, this.crsFactory, this.csFactory);
            this.defaultProperties = null;
            this.operationFactory = coordinateOperationFactory instanceof DefaultCoordinateOperationFactory ? (DefaultCoordinateOperationFactory)coordinateOperationFactory : CoordinateOperations.factory();
        }
        return this.operationFactory;
    }

    public final MathTransformFactory getMathTransformFactory() {
        if (this.mtFactory == null) {
            this.mtFactory = (MathTransformFactory)DefaultFactories.forBuildin(MathTransformFactory.class);
        }
        return this.mtFactory;
    }

    public final CartesianCS getStandardProjectedCS() throws FactoryException {
        return this.getCSAuthorityFactory().createCartesianCS("4400");
    }
}

