/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.server.tomcat;

import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.catalina.Engine;
import org.apache.naming.factory.ResourceLinkFactory;
import org.exoplatform.container.BaseContainerLifecyclePlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.wci.tomcat.TomcatServletContainerContext;

public class DataSourceInjector
extends BaseContainerLifecyclePlugin {
    private static final Log LOG = ExoLogger.getLogger(DataSourceInjector.class);

    public void initContainer(ExoContainer container) throws Exception {
        Context globalNamingContext;
        if (!(container instanceof PortalContainer)) {
            return;
        }
        PortalContainer portalContainer = (PortalContainer)container;
        String portalName = portalContainer.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("register portal container classLoader inside " + portalName));
        }
        if ((globalNamingContext = this.getGlobalNamingContext()) == null) {
            throw new IllegalStateException("Can't access Tomcat Global context");
        }
        List<String> datasourceNames = this.getListOfDatasources(globalNamingContext);
        for (String dsName : datasourceNames) {
            ResourceLinkFactory.registerGlobalResourceAccess((Context)globalNamingContext, (String)dsName, (String)dsName);
        }
    }

    private Context getGlobalNamingContext() {
        TomcatServletContainerContext servletContainerContext = TomcatServletContainerContext.getInstanceIfPresent();
        if (servletContainerContext != null) {
            Engine e = servletContainerContext.getEngine();
            return e.getService().getServer().getGlobalNamingContext();
        }
        return null;
    }

    private List<String> getListOfDatasources(Context globalNamingContext) throws NamingException {
        ArrayList<String> datasourceNames = new ArrayList<String>();
        NamingEnumeration<NameClassPair> list = globalNamingContext.list("/");
        while (list.hasMore()) {
            NameClassPair next = list.next();
            datasourceNames.add(next.getName());
        }
        return datasourceNames;
    }
}

