/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.Static;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

public final class Identifiers
extends Static {
    private Identifiers() {
    }

    public static boolean isEPSG(String string, String string2) {
        return "EPSG".equalsIgnoreCase(string2) && ("IOGP".equalsIgnoreCase(string) || "OGP".equalsIgnoreCase(string) || "EPSG".equalsIgnoreCase(string));
    }

    private static boolean isDeprecated(Object object) {
        return object instanceof Deprecable && ((Deprecable)object).isDeprecated();
    }

    private static String toString(InternationalString internationalString) {
        return internationalString != null && !Identifiers.isDeprecated(internationalString) ? CharSequences.trimWhitespaces((String)internationalString.toString(Locale.ROOT)) : null;
    }

    public static String getIdentifier(Citation citation, boolean bl) {
        if (citation != null) {
            String string;
            Object object;
            boolean bl2 = false;
            String string2 = null;
            String string3 = null;
            Iterator iterator = CollectionsExt.nonEmptyIterator((Collection)citation.getIdentifiers());
            if (iterator != null) {
                while (iterator.hasNext()) {
                    object = (Identifier)iterator.next();
                    if (object == null || Identifiers.isDeprecated(object) || (string = CharSequences.trimWhitespaces((String)object.getCode())) == null || string.isEmpty()) continue;
                    String string4 = null;
                    if (object instanceof ReferenceIdentifier) {
                        string4 = CharSequences.trimWhitespaces((String)((ReferenceIdentifier)object).getCodeSpace());
                    }
                    if (string4 == null || string4.isEmpty()) {
                        string4 = null;
                        bl2 = CharSequences.isUnicodeIdentifier((CharSequence)string);
                    } else {
                        bl2 = CharSequences.isUnicodeIdentifier((CharSequence)string4);
                        if (bl2) {
                            int n;
                            for (int i = 0; i < string.length(); i += Character.charCount(n)) {
                                n = string.codePointAt(i);
                                if (Character.isUnicodeIdentifierPart(n) || !bl && (n == 46 || n == 45)) continue;
                                bl2 = false;
                                break;
                            }
                        }
                    }
                    if (string2 != null && !bl2) continue;
                    string2 = string;
                    string3 = string4;
                    if (!bl2) continue;
                    break;
                }
            }
            if (string2 == null) {
                string2 = Identifiers.toString(citation.getTitle());
                if (string2 != null) {
                    if (string2.isEmpty()) {
                        string2 = null;
                    } else {
                        bl2 = CharSequences.isUnicodeIdentifier((CharSequence)string2);
                    }
                }
                if (!bl2 && (object = CollectionsExt.nonEmptyIterator((Collection)citation.getAlternateTitles())) != null) {
                    while (object.hasNext()) {
                        string = Identifiers.toString((InternationalString)object.next());
                        if (string == null || string.isEmpty()) continue;
                        bl2 = CharSequences.isUnicodeIdentifier((CharSequence)string);
                        if (string2 != null && !bl2) continue;
                        string2 = string;
                        if (!bl2) continue;
                        break;
                    }
                }
            }
            if (bl2 || !bl) {
                if (string3 != null && !Identifiers.isEPSG(string3, string2)) {
                    return string3 + (bl ? (char)'_' : ':') + string2;
                }
                return string2;
            }
        }
        return null;
    }

    private static boolean authorityMatches(Identifier identifier, Citation citation, String string) {
        Object object;
        if (citation != null && (object = identifier.getAuthority()) != null) {
            return Citations.identifierMatches(citation, object);
        }
        if (string != null && identifier instanceof ReferenceIdentifier && (object = ((ReferenceIdentifier)identifier).getCodeSpace()) != null) {
            return CharSequences.equalsFiltered((CharSequence)string, (CharSequence)object, (Characters.Filter)Characters.Filter.UNICODE_IDENTIFIER, (boolean)true);
        }
        return false;
    }

    public static Boolean hasCommonIdentifier(Iterable<? extends ReferenceIdentifier> iterable, Iterable<? extends ReferenceIdentifier> iterable2) {
        if (iterable != null && iterable2 != null) {
            boolean bl = false;
            for (ReferenceIdentifier referenceIdentifier : iterable) {
                Citation citation = referenceIdentifier.getAuthority();
                String string = referenceIdentifier.getCodeSpace();
                for (Identifier identifier : iterable2) {
                    if (!Identifiers.authorityMatches((Identifier)referenceIdentifier, citation, string)) continue;
                    if (CharSequences.equalsFiltered((CharSequence)referenceIdentifier.getCode(), (CharSequence)identifier.getCode(), (Characters.Filter)Characters.Filter.UNICODE_IDENTIFIER, (boolean)true)) {
                        return Boolean.TRUE;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

