/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.httpcore.middlewareoption;

import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.httpcore.middlewareoption.IMiddlewareControl;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.httpcore.middlewareoption.IShouldRetry;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.okhttp3.Request;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.okhttp3.Response;

public class RetryOptions
implements IMiddlewareControl {
    private IShouldRetry mShouldretry;
    public static final IShouldRetry DEFAULT_SHOULD_RETRY = new IShouldRetry(){

        @Override
        public boolean shouldRetry(long delay, int executionCount, Request request, Response response) {
            return true;
        }
    };
    private int mMaxRetries;
    public static final int MAX_RETRIES = 10;
    public static final int DEFAULT_MAX_RETRIES = 3;
    private long mDelay;
    public static final long DEFAULT_DELAY = 3L;
    public static final long MAX_DELAY = 180L;

    public RetryOptions() {
        this(DEFAULT_SHOULD_RETRY, 3, 3L);
    }

    public RetryOptions(IShouldRetry shouldRetry, int maxRetries, long delay) {
        if (delay > 180L) {
            throw new IllegalArgumentException("Delay cannot exceed 180");
        }
        if (delay < 0L) {
            throw new IllegalArgumentException("Delay cannot be negative");
        }
        if (maxRetries > 10) {
            throw new IllegalArgumentException("Max retries cannot exceed 10");
        }
        if (maxRetries < 0) {
            throw new IllegalArgumentException("Max retries cannot be negative");
        }
        this.mShouldretry = shouldRetry != null ? shouldRetry : DEFAULT_SHOULD_RETRY;
        this.mMaxRetries = maxRetries;
        this.mDelay = delay;
    }

    public IShouldRetry shouldRetry() {
        return this.mShouldretry;
    }

    public int maxRetries() {
        return this.mMaxRetries;
    }

    public long delay() {
        return this.mDelay;
    }
}

