/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql;

import java.util.Map;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.sql.MetadataSource;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;

final class LookupInfo {
    private Class<?> type;
    private Map<String, String> names;
    private Map<String, Integer> indices;
    private ObjectConverter<?, ?> converter;

    LookupInfo() {
    }

    final Class<?> getMetadataType() {
        return this.type;
    }

    final void setMetadataType(Class<?> clazz) {
        if (this.type != clazz) {
            this.type = clazz;
            this.names = null;
            this.indices = null;
        }
    }

    final Map<String, String> asNameMap(MetadataStandard metadataStandard) {
        if (this.names == null) {
            this.names = metadataStandard.asNameMap(this.type, KeyNamePolicy.METHOD_NAME, MetadataSource.NAME_POLICY);
        }
        return this.names;
    }

    final Map<String, Integer> asIndexMap(MetadataStandard metadataStandard) {
        if (this.indices == null) {
            this.indices = metadataStandard.asIndexMap(this.type, KeyNamePolicy.METHOD_NAME);
        }
        return this.indices;
    }

    final Object convert(Class<?> clazz, Object object) {
        Class<?> clazz2 = object.getClass();
        if (!clazz.isAssignableFrom(clazz2)) {
            if (this.converter == null || !this.converter.getSourceClass().isAssignableFrom(clazz2) || !clazz.isAssignableFrom(this.converter.getTargetClass())) {
                this.converter = ObjectConverters.find(clazz2, clazz);
            }
            object = this.converter.apply(object);
        }
        return object;
    }
}

