/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.queue.service;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.exoplatform.analytics.api.service.StatisticDataProcessorService;
import org.exoplatform.analytics.api.service.StatisticDataQueueService;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.model.StatisticDataQueueEntry;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class DummyStatisticDataQueueService
implements StatisticDataQueueService,
Startable {
    private static final Log LOG = ExoLogger.getLogger(DummyStatisticDataQueueService.class);
    private static final String ANALYTICS_QUEUE_CACHE_NAME = "analytics.queue";
    private ExoCache<Long, StatisticDataQueueEntry> statisticQueueCache = null;
    private StatisticDataProcessorService statisticDataProcessorService;
    private ScheduledExecutorService queueProcessingExecutor = null;
    private PortalContainer container = null;
    private BigInteger totalExecutionTime = BigInteger.ZERO;
    private long lastExecutionTime = 0L;
    private long executionCount = 0L;

    public DummyStatisticDataQueueService(PortalContainer container, StatisticDataProcessorService statisticDataProcessorService, CacheService cacheService) {
        this.statisticDataProcessorService = statisticDataProcessorService;
        this.container = container;
        this.statisticQueueCache = cacheService.getCacheInstance(ANALYTICS_QUEUE_CACHE_NAME);
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("Analytics-ingestor-%d").build();
        this.queueProcessingExecutor = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
    }

    public void start() {
        this.queueProcessingExecutor.scheduleAtFixedRate(() -> {
            ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
            RequestLifeCycle.begin((ExoContainer)this.container);
            try {
                this.processQueue();
            }
            finally {
                RequestLifeCycle.end();
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQueue() {
        ++this.executionCount;
        long startTime = System.currentTimeMillis();
        try {
            List queueEntries = this.statisticQueueCache.getCachedObjects();
            LOG.debug("Processing {} documents", new Object[]{queueEntries.size()});
            this.statisticDataProcessorService.process(queueEntries);
            for (StatisticDataQueueEntry statisticDataQueueEntry : queueEntries) {
                if (!statisticDataQueueEntry.isProcessed()) continue;
                this.statisticQueueCache.remove((Serializable)Long.valueOf(statisticDataQueueEntry.getId()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while processing statistic documents from queue", (Throwable)e);
        }
        finally {
            this.lastExecutionTime = System.currentTimeMillis() - startTime;
            this.totalExecutionTime = this.totalExecutionTime.add(BigInteger.valueOf(this.lastExecutionTime));
        }
    }

    public void stop() {
        this.queueProcessingExecutor.shutdown();
    }

    public void put(StatisticData data) {
        StatisticDataQueueEntry statisticDataQueueEntry = new StatisticDataQueueEntry(data);
        this.statisticQueueCache.put((Serializable)Long.valueOf(statisticDataQueueEntry.getId()), (Object)statisticDataQueueEntry);
    }

    public StatisticData get(long id) {
        StatisticDataQueueEntry statisticDataQueueEntry = (StatisticDataQueueEntry)this.statisticQueueCache.get((Serializable)Long.valueOf(id));
        return statisticDataQueueEntry == null ? null : statisticDataQueueEntry.getStatisticData();
    }

    public int queueSize() {
        return this.statisticQueueCache.getCacheSize();
    }

    public long getAverageExecutionTime() {
        if (this.executionCount < 2L) {
            return this.totalExecutionTime.longValue();
        }
        return this.totalExecutionTime.divide(BigInteger.valueOf(this.executionCount)).longValue();
    }

    public long getExecutionCount() {
        return this.executionCount;
    }

    public long getLastExecutionTime() {
        return this.lastExecutionTime;
    }
}

