/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.http.jetty;

import java.net.HttpCookie;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Promise;
import org.cometd.client.http.common.AbstractHttpClientTransport;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.TransportListener;
import org.cometd.common.BufferingJSONAsyncParser;
import org.cometd.common.JSONContext;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.StringRequestContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyHttpClientTransport
extends AbstractHttpClientTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyHttpClientTransport.class);
    private final AutoLock lock = new AutoLock();
    private final List<Request> requests = new ArrayList<Request>();
    private final HttpClient httpClient;

    public JettyHttpClientTransport(Map<String, Object> options, HttpClient httpClient) {
        this(null, options, httpClient);
    }

    public JettyHttpClientTransport(String url, Map<String, Object> options, HttpClient httpClient) {
        this(url, options, null, httpClient);
    }

    public JettyHttpClientTransport(String url, Map<String, Object> options, ScheduledExecutorService scheduler, HttpClient httpClient) {
        super(url, options, scheduler);
        this.httpClient = Objects.requireNonNull(httpClient);
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void init() {
        super.init();
        long defaultMaxNetworkDelay = this.getHttpClient().getIdleTimeout();
        if (defaultMaxNetworkDelay <= 0L) {
            defaultMaxNetworkDelay = 10000L;
        }
        this.setMaxNetworkDelay(defaultMaxNetworkDelay);
    }

    public void abort(Throwable failure) {
        ArrayList<Request> requests;
        try (AutoLock l = this.lock.lock();){
            super.abort(failure);
            requests = new ArrayList<Request>(this.requests);
            this.requests.clear();
        }
        for (Request request : requests) {
            request.abort(failure);
        }
    }

    public void send(TransportListener listener, List<Message.Mutable> messages) {
        try {
            String requestURI = this.newRequestURI(messages);
            Request request = this.httpClient.newRequest(requestURI).method(HttpMethod.POST);
            request.headers(headers -> headers.put(HttpHeader.CONTENT_TYPE, "application/json;charset=UTF-8"));
            URI cookieURI = URI.create(this.getURL());
            List cookies = this.getCookies(cookieURI);
            StringBuilder value = new StringBuilder(cookies.size() * 32);
            for (HttpCookie cookie : cookies) {
                if (value.length() > 0) {
                    value.append("; ");
                }
                value.append(cookie.getName()).append("=").append(cookie.getValue());
            }
            request.headers(headers -> headers.put(HttpHeader.COOKIE, value.toString()));
            request.body((Request.Content)new StringRequestContent(this.generateJSON(messages)));
            this.customize(request, (Promise<Request>)Promise.from(customizedRequest -> this.send(listener, messages, cookieURI, (Request)customizedRequest), error -> listener.onFailure(error, messages)));
        }
        catch (Throwable x) {
            listener.onFailure(x, messages);
        }
    }

    private void send(final TransportListener listener, final List<Message.Mutable> messages, URI cookieURI, Request request) {
        request.listener((Request.Listener)new Request.Listener.Adapter(){

            public void onHeaders(Request request) {
                listener.onSending(messages);
            }
        });
        long maxNetworkDelay = this.calculateMaxNetworkDelay(messages);
        request.idleTimeout(0L, TimeUnit.MILLISECONDS);
        AtomicReference timeoutTaskRef = new AtomicReference();
        ScheduledExecutorService scheduler = this.getScheduler();
        if (scheduler != null) {
            ScheduledFuture<?> newTask = scheduler.schedule(() -> this.onTimeout(listener, messages, request, maxNetworkDelay, timeoutTaskRef), maxNetworkDelay, TimeUnit.MILLISECONDS);
            timeoutTaskRef.set(newTask);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Started waiting for message replies, {} ms, task@{}", (Object)maxNetworkDelay, (Object)Integer.toHexString(newTask.hashCode()));
            }
        }
        request.onComplete(result -> {
            ScheduledFuture task = (ScheduledFuture)timeoutTaskRef.get();
            if (task != null) {
                task.cancel(false);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Cancelled waiting for message replies, task@{}", (Object)Integer.toHexString(task.hashCode()));
                }
            }
        });
        try (AutoLock l = this.lock.lock();){
            if (!this.isAborted()) {
                this.requests.add(request);
            }
        }
        request.send((Response.CompleteListener)new ResponseListener(listener, messages, cookieURI));
    }

    private void onTimeout(TransportListener listener, List<? extends Message> messages, Request request, long delay, AtomicReference<ScheduledFuture<?>> timeoutTaskRef) {
        listener.onTimeout(messages, Promise.from(result -> {
            if (result > 0L) {
                ScheduledExecutorService scheduler = this.getScheduler();
                if (scheduler != null) {
                    ScheduledFuture<?> newTask = scheduler.schedule(() -> this.onTimeout(listener, messages, request, delay + result, timeoutTaskRef), (long)result, TimeUnit.MILLISECONDS);
                    ScheduledFuture<?> oldTask = timeoutTaskRef.getAndSet(newTask);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Extended waiting for message replies, {} ms, oldTask@{}, newTask@{}", new Object[]{result, Integer.toHexString(oldTask.hashCode()), Integer.toHexString(newTask.hashCode())});
                    }
                }
            } else {
                request.abort((Throwable)new TimeoutException("Network delay expired: " + delay + " ms"));
            }
        }, arg_0 -> ((Request)request).abort(arg_0)));
    }

    protected void customize(Request request) {
    }

    protected void customize(Request request, Promise<Request> promise) {
        try {
            this.customize(request);
            promise.succeed((Object)request);
        }
        catch (Throwable x) {
            promise.fail(x);
        }
    }

    private class ResponseListener
    implements Response.Listener {
        private final TransportListener listener;
        private final List<Message.Mutable> outgoing;
        private final URI cookieURI;
        private long contentLength;
        private JSONContext.AsyncParser parser;

        private ResponseListener(TransportListener listener, List<Message.Mutable> messages, URI cookieURI) {
            this.listener = listener;
            this.outgoing = messages;
            this.cookieURI = cookieURI;
        }

        public boolean onHeader(Response response, HttpField field) {
            HttpHeader header;
            if (response.getStatus() == 200 && ((header = field.getHeader()) == HttpHeader.SET_COOKIE || header == HttpHeader.SET_COOKIE2)) {
                HashMap<String, List<String>> cookies = new HashMap<String, List<String>>(1);
                cookies.put(field.getName(), List.of(field.getValue()));
                JettyHttpClientTransport.this.storeCookies(this.cookieURI, cookies);
                return false;
            }
            return true;
        }

        public void onHeaders(Response response) {
            if (response.getStatus() == 200) {
                JSONContext.Client jsonContext = JettyHttpClientTransport.this.getJSONContextClient();
                this.parser = jsonContext.newAsyncParser();
                if (this.parser == null) {
                    this.parser = new BufferingJSONAsyncParser((JSONContext)jsonContext);
                }
            }
        }

        public void onContent(Response response, ByteBuffer content) {
            if (response.getStatus() == 200) {
                this.contentLength += (long)content.remaining();
                int maxLength = JettyHttpClientTransport.this.getMaxMessageSize();
                if (maxLength > 0 && this.contentLength > (long)maxLength) {
                    response.abort((Throwable)new IllegalArgumentException("Buffering capacity " + maxLength + " exceeded"));
                } else {
                    this.parse(response, content);
                }
            }
        }

        public void onComplete(Result result) {
            try (AutoLock l = JettyHttpClientTransport.this.lock.lock();){
                JettyHttpClientTransport.this.requests.remove(result.getRequest());
            }
            if (result.isFailed()) {
                this.listener.onFailure(result.getFailure(), this.outgoing);
                return;
            }
            try {
                Response response = result.getResponse();
                int status = response.getStatus();
                if (status == 200) {
                    List incoming = (List)this.parser.complete();
                    JettyHttpClientTransport.this.processResponseMessages(this.listener, incoming);
                } else {
                    JettyHttpClientTransport.this.processWrongResponseCode(this.listener, this.outgoing, status);
                }
            }
            catch (Throwable x) {
                this.listener.onFailure(x, this.outgoing);
            }
        }

        private void parse(Response response, ByteBuffer content) {
            try {
                this.parser.parse(content);
            }
            catch (Throwable x) {
                response.abort(x);
            }
        }
    }

    public static class Factory
    extends ContainerLifeCycle
    implements ClientTransport.Factory {
        private final HttpClient httpClient;

        public Factory() {
            this(new HttpClient());
        }

        public Factory(HttpClient httpClient) {
            this.httpClient = httpClient;
            this.addBean(httpClient);
        }

        public ClientTransport newClientTransport(String url, Map<String, Object> options) {
            return new JettyHttpClientTransport(url, options, this.httpClient);
        }
    }
}

