/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.IOException;
import java.io.InputStream;
import liquibase.AbstractExtensibleObject;
import liquibase.Scope;
import liquibase.resource.InputStreamList;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtil;

public abstract class AbstractResourceAccessor
extends AbstractExtensibleObject
implements ResourceAccessor {
    @Override
    public InputStream openStream(String relativeTo, String streamPath) throws IOException {
        InputStreamList streamList = this.openStreams(relativeTo, streamPath);
        if (streamList == null || streamList.size() == 0) {
            return null;
        }
        if (streamList.size() > 1) {
            streamList.close();
            Scope.getCurrentScope().getLog(this.getClass()).warning("ResourceAccessor roots: " + Scope.getCurrentScope().getResourceAccessor().getClass().getName());
            throw new IOException("Found " + streamList.size() + " files that match " + streamPath + ": " + StringUtil.join(streamList.getURIs(), ", ", (StringUtil.StringUtilFormatter)new StringUtil.ToStringFormatter()));
        }
        return streamList.iterator().next();
    }
}

