/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Point;
import java.awt.image.ImagingOpException;
import java.awt.image.TileObserver;
import java.awt.image.WritableRenderedImage;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.image.ComputedImage;
import org.apache.sis.image.TileCache;
import org.apache.sis.internal.system.ReferenceQueueConsumer;
import org.apache.sis.util.Disposable;

final class ComputedTiles
extends WeakReference<ComputedImage>
implements Disposable,
TileObserver {
    private static final int VALID = 0;
    private static final int DIRTY = -1;
    private static final int ERROR = -2;
    private static final int COMPUTING = 1;
    private final Map<TileCache.Key, Integer> cachedTiles = new HashMap<TileCache.Key, Integer>();
    private WritableRenderedImage[] sources;

    ComputedTiles(ComputedImage computedImage, WritableRenderedImage[] writableRenderedImageArray) {
        super(computedImage, ReferenceQueueConsumer.QUEUE);
        this.sources = writableRenderedImageArray;
        if (writableRenderedImageArray != null) {
            int n = 0;
            try {
                while (n < writableRenderedImageArray.length) {
                    WritableRenderedImage writableRenderedImage = writableRenderedImageArray[n++];
                    writableRenderedImage.addTileObserver(this);
                }
            }
            catch (RuntimeException runtimeException) {
                this.unregister(writableRenderedImageArray, n, runtimeException);
            }
        }
    }

    private static boolean isWritable(Integer n) {
        if (n == null) {
            return false;
        }
        int n2 = n;
        return n2 >= 1 || n2 < -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isTileWritable(TileCache.Key key) {
        Integer n;
        Map<TileCache.Key, Integer> map = this.cachedTiles;
        synchronized (map) {
            n = this.cachedTiles.get(key);
        }
        return ComputedTiles.isWritable(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isTileDirty(TileCache.Key key) {
        Integer n;
        Map<TileCache.Key, Integer> map = this.cachedTiles;
        synchronized (map) {
            n = this.cachedTiles.get(key);
        }
        if (n != null) {
            switch (n) {
                case -1: {
                    break;
                }
                case -2: {
                    throw new ImagingOpException(key.error((short)60));
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean trySetComputing(TileCache.Key key) {
        Integer n;
        Map<TileCache.Key, Integer> map = this.cachedTiles;
        synchronized (map) {
            n = this.cachedTiles.putIfAbsent(key, 1);
            if (n == null || this.cachedTiles.replace(key, -1, 1)) {
                return true;
            }
        }
        if (n == -2) {
            throw new ImagingOpException(key.error((short)60));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean startWrite(TileCache.Key key) {
        Integer n = 1;
        Map<TileCache.Key, Integer> map = this.cachedTiles;
        synchronized (map) {
            n = this.cachedTiles.merge(key, n, ComputedTiles::increment);
        }
        return n == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean endWrite(TileCache.Key key, boolean bl) {
        int n = bl ? 0 : -2;
        Integer n2 = n;
        Map<TileCache.Key, Integer> map = this.cachedTiles;
        synchronized (map) {
            n2 = this.cachedTiles.merge(key, n2, ComputedTiles::decrement);
        }
        return n2 == n;
    }

    private static Integer increment(Integer n, Integer n2) {
        int n3 = n;
        switch (n3) {
            case -2: 
            case -1: 
            case 0: {
                return n2;
            }
            case -3: {
                throw new ArithmeticException();
            }
        }
        return n3 + 1;
    }

    private static Integer decrement(Integer n, Integer n2) {
        int n3 = n;
        if (n3 >= -2 && n3 <= 1) {
            return n2;
        }
        return n3 - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean getWritableTileIndices(List<Point> list) {
        Map<TileCache.Key, Integer> map = this.cachedTiles;
        synchronized (map) {
            for (Map.Entry<TileCache.Key, Integer> entry : this.cachedTiles.entrySet()) {
                if (!ComputedTiles.isWritable(entry.getValue())) continue;
                if (list == null) {
                    return true;
                }
                list.add(entry.getKey().indices());
            }
        }
        return list != null && !list.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean markDirtyTiles(int n, int n2, int n3, int n4, boolean bl) {
        Integer n5 = bl ? -2 : 0;
        Integer n6 = -1;
        boolean bl2 = false;
        Map<TileCache.Key, Integer> map = this.cachedTiles;
        synchronized (map) {
            for (int i = n2; i <= n4; ++i) {
                for (int j = n; j <= n3; ++j) {
                    TileCache.Key key = new TileCache.Key(this, j, i);
                    bl2 |= this.cachedTiles.replace(key, n5, n6);
                }
            }
        }
        return bl2;
    }

    @Override
    public void tileUpdate(WritableRenderedImage writableRenderedImage, int n, int n2, boolean bl) {
        if (!bl) {
            ComputedImage computedImage = (ComputedImage)this.get();
            if (computedImage != null) {
                computedImage.sourceTileChanged(writableRenderedImage, n, n2);
            } else {
                writableRenderedImage.removeTileObserver(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        WritableRenderedImage[] writableRenderedImageArray = this.cachedTiles;
        synchronized (this.cachedTiles) {
            this.cachedTiles.keySet().forEach(TileCache.Key::dispose);
            this.cachedTiles.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            writableRenderedImageArray = this.sources;
            if (writableRenderedImageArray != null) {
                this.unregister(writableRenderedImageArray, writableRenderedImageArray.length, null);
            }
            return;
        }
    }

    private void unregister(WritableRenderedImage[] writableRenderedImageArray, int n, RuntimeException runtimeException) {
        this.sources = null;
        while (--n >= 0) {
            try {
                writableRenderedImageArray[n].removeTileObserver(this);
            }
            catch (RuntimeException runtimeException2) {
                if (runtimeException == null) {
                    runtimeException = runtimeException2;
                    continue;
                }
                runtimeException.addSuppressed(runtimeException2);
            }
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }
}

