/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Disposable;

abstract class ImageAdapter
extends PlanarImage {
    protected final RenderedImage source;

    protected ImageAdapter(RenderedImage renderedImage) {
        ArgumentChecks.ensureNonNull((String)"source", (Object)renderedImage);
        this.source = renderedImage;
    }

    @Override
    public final Vector<RenderedImage> getSources() {
        Vector<RenderedImage> vector = new Vector<RenderedImage>(1);
        vector.add(this.source);
        return vector;
    }

    @Override
    public String[] getPropertyNames() {
        return this.source.getPropertyNames();
    }

    @Override
    public Object getProperty(String string) {
        return this.source.getProperty(string);
    }

    @Override
    public ColorModel getColorModel() {
        return this.source.getColorModel();
    }

    @Override
    public final SampleModel getSampleModel() {
        return this.source.getSampleModel();
    }

    @Override
    public final int getWidth() {
        return this.source.getWidth();
    }

    @Override
    public final int getHeight() {
        return this.source.getHeight();
    }

    @Override
    public final int getMinX() {
        return this.source.getMinX();
    }

    @Override
    public final int getMinY() {
        return this.source.getMinY();
    }

    @Override
    public final int getNumXTiles() {
        return this.source.getNumXTiles();
    }

    @Override
    public final int getNumYTiles() {
        return this.source.getNumYTiles();
    }

    @Override
    public final int getMinTileX() {
        return this.source.getMinTileX();
    }

    @Override
    public final int getMinTileY() {
        return this.source.getMinTileY();
    }

    @Override
    public final int getTileWidth() {
        return this.source.getTileWidth();
    }

    @Override
    public final int getTileHeight() {
        return this.source.getTileHeight();
    }

    @Override
    public final int getTileGridXOffset() {
        return this.source.getTileGridXOffset();
    }

    @Override
    public final int getTileGridYOffset() {
        return this.source.getTileGridYOffset();
    }

    @Override
    public final Raster getTile(int n, int n2) {
        return this.source.getTile(n, n2);
    }

    @Override
    public final Raster getData() {
        return this.source.getData();
    }

    @Override
    public final Raster getData(Rectangle rectangle) {
        return this.source.getData(rectangle);
    }

    @Override
    public final WritableRaster copyData(WritableRaster writableRaster) {
        return this.source.copyData(writableRaster);
    }

    @Override
    protected Disposable prefetch(Rectangle rectangle) {
        if (this.source instanceof PlanarImage) {
            return ((PlanarImage)this.source).prefetch(rectangle);
        }
        return super.prefetch(rectangle);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            return this.source.equals(((ImageAdapter)object).source);
        }
        return false;
    }

    public int hashCode() {
        return this.source.hashCode() ^ this.getClass().hashCode();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        Class<? extends ImageAdapter> clazz = this.appendStringContent(stringBuilder.append('['));
        return stringBuilder.insert(0, clazz.getSimpleName()).append(" on ").append(this.source).append(']').toString();
    }

    abstract Class<? extends ImageAdapter> appendStringContent(StringBuilder var1);
}

