/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import java.util.List;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.Static;

public final class SampleDimensions
extends Static {
    private SampleDimensions() {
    }

    public static Number[] backgrounds(List<SampleDimension> list) {
        if (list == null) {
            return null;
        }
        Number[] numberArray = new Number[list.size()];
        int n = numberArray.length;
        while (--n >= 0) {
            SampleDimension sampleDimension = list.get(n);
            Optional<Number> optional = sampleDimension.getBackground();
            if (!optional.isPresent()) continue;
            numberArray[n] = optional.get();
        }
        return numberArray;
    }

    public static DoubleUnaryOperator[] toSampleFilters(ImageProcessor imageProcessor, List<SampleDimension> list) {
        if (list == null) {
            return null;
        }
        DoubleUnaryOperator[] doubleUnaryOperatorArray = new DoubleUnaryOperator[list.size()];
        for (int i = 0; i < doubleUnaryOperatorArray.length; ++i) {
            SampleDimension sampleDimension = list.get(i);
            if (sampleDimension == null) continue;
            List<Category> list2 = sampleDimension.getCategories();
            Number[] numberArray = new Number[list2.size()];
            for (int j = 0; j < numberArray.length; ++j) {
                Number number;
                Category category = list2.get(j);
                if (category.isQuantitative()) continue;
                NumberRange<?> numberRange = category.getSampleRange();
                if (numberRange.isMinIncluded()) {
                    number = (Number)((Object)numberRange.getMinValue());
                } else {
                    if (!numberRange.isMaxIncluded()) continue;
                    number = (Number)((Object)numberRange.getMaxValue());
                }
                numberArray[j] = number;
            }
            doubleUnaryOperatorArray[i] = imageProcessor.filterNodataValues(numberArray);
        }
        return doubleUnaryOperatorArray;
    }
}

