/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.filter.sqlmm;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.sis.filter.Expression;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.filter.sqlmm.FunctionWithSRID;
import org.apache.sis.internal.filter.sqlmm.SQLMM;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class ST_Point<R, G>
extends FunctionWithSRID<R> {
    private static final long serialVersionUID = -6280773709322350835L;
    private final Expression<? super R, ?>[] parameters;
    private final Geometries<G> library;

    ST_Point(Expression<? super R, ?>[] expressionArray, Geometries<G> geometries) {
        super(SQLMM.ST_Point, expressionArray, 2);
        this.parameters = expressionArray;
        this.library = geometries;
    }

    @Override
    public Expression<R, Object> recreate(Expression<? super R, ?>[] expressionArray) {
        return new ST_Point(expressionArray, this.getGeometryLibrary());
    }

    @Override
    final Geometries<?> getGeometryLibrary() {
        return this.library;
    }

    @Override
    public List<Expression<? super R, ?>> getParameters() {
        return UnmodifiableArrayList.wrap((Object[])this.parameters);
    }

    private double value(R r, int n, String string) {
        Object obj = this.parameters[n].apply(r);
        if (obj == null) {
            return Double.NaN;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        throw new IllegalArgumentException(Errors.format((short)43, (Object)string, Number.class, obj.getClass()));
    }

    private GeometryWrapper<G> parse(Object object) throws Exception {
        GeometryWrapper<G> geometryWrapper;
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            geometryWrapper = this.library.parseWKB(ByteBuffer.wrap((byte[])object));
        } else if (object instanceof ByteBuffer) {
            geometryWrapper = this.library.parseWKB((ByteBuffer)object);
        } else if (object instanceof String) {
            geometryWrapper = this.library.parseWKT((String)object);
        } else {
            throw new IllegalArgumentException(Errors.format((short)43, (Object)"wkt|wkb", String.class, object.getClass()));
        }
        Object object2 = geometryWrapper.implementation();
        if (this.library.pointClass.isInstance(object2)) {
            return geometryWrapper;
        }
        String string = object instanceof String ? "wkt" : "wkb";
        throw new IllegalArgumentException(Errors.format((short)43, (Object)string, this.library.pointClass, geometryWrapper.getClass()));
    }

    @Override
    public Object apply(R r) {
        CoordinateReferenceSystem coordinateReferenceSystem;
        GeometryWrapper<G> geometryWrapper;
        try {
            switch (this.parameters.length) {
                case 1: {
                    GeometryWrapper<G> geometryWrapper2 = this.parse(this.parameters[0].apply(r));
                    return geometryWrapper2 != null ? geometryWrapper2.implementation() : null;
                }
                case 2: {
                    Object obj = this.parameters[0].apply(r);
                    if (obj instanceof Number) {
                        double d = ((Number)obj).doubleValue();
                        double d2 = this.value(r, 1, "y");
                        if (Double.isNaN(d) && Double.isNaN(d2)) {
                            return null;
                        }
                        return this.library.createPoint(d, d2);
                    }
                    geometryWrapper = this.parse(obj);
                    if (geometryWrapper == null) {
                        return null;
                    }
                    coordinateReferenceSystem = this.getTargetCRS(r);
                    break;
                }
                case 3: {
                    double d = this.value(r, 0, "x");
                    double d3 = this.value(r, 1, "y");
                    if (this.literalCRS) {
                        if (Double.isNaN(d) && Double.isNaN(d3)) {
                            return null;
                        }
                        geometryWrapper = this.library.castOrWrap(this.library.createPoint(d, d3));
                        coordinateReferenceSystem = this.getTargetCRS(r);
                        break;
                    }
                    double d4 = this.value(r, 2, "z");
                    if (Double.isNaN(d) && Double.isNaN(d3) && Double.isNaN(d4)) {
                        return null;
                    }
                    return this.library.createPoint(d, d3, d4);
                }
                case 4: {
                    double d = this.value(r, 0, "x");
                    double d5 = this.value(r, 1, "y");
                    double d6 = this.value(r, 2, "z");
                    if (Double.isNaN(d) && Double.isNaN(d5) && Double.isNaN(d6)) {
                        return null;
                    }
                    geometryWrapper = this.library.castOrWrap(this.library.createPoint(d, d5, d6));
                    coordinateReferenceSystem = this.getTargetCRS(r);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            this.warning(exception, false);
            return null;
        }
        if (coordinateReferenceSystem != null) {
            geometryWrapper.setCoordinateReferenceSystem(coordinateReferenceSystem);
        }
        return geometryWrapper.implementation();
    }
}

