/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity;

import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.common.ListAccessValidator;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.RelationshipStorage;

public class ConnectionFilterListAccess
implements ListAccess<Identity> {
    private IdentityStorage identityStorage;
    private RelationshipStorage relationshipStorage;
    Identity identity;
    Type type;
    ProfileFilter profileFilter;

    public ConnectionFilterListAccess(IdentityStorage identityStorage, RelationshipStorage relationshipStorage, Identity identity, ProfileFilter filter) {
        this.relationshipStorage = relationshipStorage;
        this.identityStorage = identityStorage;
        this.identity = identity;
        this.profileFilter = filter;
        if (this.profileFilter.getViewerIdentity() == null) {
            this.profileFilter.setViewerIdentity(identity);
        }
    }

    public ConnectionFilterListAccess(IdentityStorage identityStorage, RelationshipStorage relationshipStorage, Identity identity, ProfileFilter filter, Type type) {
        this(identityStorage, relationshipStorage, identity, filter);
        if (type == null) {
            throw new IllegalArgumentException("Type of Connection list access is mandatory");
        }
        this.type = type;
    }

    public Identity[] load(int offset, int limit) throws Exception {
        ListAccessValidator.validateIndex((int)offset, (int)limit, (int)this.getSize());
        List identities = null;
        if (this.profileFilter.isEmpty()) {
            switch (this.type) {
                case PROFILE_FILTER_CONNECTION: {
                    identities = this.relationshipStorage.getConnectionsByFilter(this.identity, this.profileFilter, (long)offset, (long)limit);
                    break;
                }
                case PROFILE_FILTER_INCOMMING: {
                    identities = this.relationshipStorage.getIncomingByFilter(this.identity, this.profileFilter, (long)offset, (long)limit);
                    break;
                }
                case PROFILE_FILTER_OUTGOING: {
                    identities = this.relationshipStorage.getOutgoingByFilter(this.identity, this.profileFilter, (long)offset, (long)limit);
                }
            }
        } else {
            Relationship.Type relationShipType = null;
            switch (this.type) {
                case PROFILE_FILTER_CONNECTION: {
                    relationShipType = Relationship.Type.CONFIRMED;
                    break;
                }
                case PROFILE_FILTER_INCOMMING: {
                    relationShipType = Relationship.Type.INCOMING;
                    break;
                }
                case PROFILE_FILTER_OUTGOING: {
                    relationShipType = Relationship.Type.OUTGOING;
                }
            }
            identities = this.identityStorage.getIdentitiesForMentions("organization", this.profileFilter, relationShipType, (long)offset, (long)limit, true);
        }
        if (identities == null) {
            return null;
        }
        return identities.toArray(new Identity[identities.size()]);
    }

    public int getSize() throws Exception {
        if (this.profileFilter.isEmpty()) {
            switch (this.type) {
                case PROFILE_FILTER_CONNECTION: {
                    return this.relationshipStorage.getConnectionsCountByFilter(this.identity, this.profileFilter);
                }
                case PROFILE_FILTER_INCOMMING: {
                    return this.relationshipStorage.getIncomingCountByFilter(this.identity, this.profileFilter);
                }
                case PROFILE_FILTER_OUTGOING: {
                    return this.relationshipStorage.getOutgoingCountByFilter(this.identity, this.profileFilter);
                }
            }
            return 0;
        }
        Relationship.Type relationShipType = null;
        switch (this.type) {
            case PROFILE_FILTER_CONNECTION: {
                relationShipType = Relationship.Type.CONFIRMED;
                break;
            }
            case PROFILE_FILTER_INCOMMING: {
                relationShipType = Relationship.Type.INCOMING;
                break;
            }
            case PROFILE_FILTER_OUTGOING: {
                relationShipType = Relationship.Type.OUTGOING;
            }
        }
        return this.identityStorage.getIdentitiesForMentionsCount("organization", this.profileFilter, relationShipType);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public static enum Type {
        PROFILE_FILTER_INCOMMING,
        PROFILE_FILTER_OUTGOING,
        PROFILE_FILTER_CONNECTION;

    }
}

