/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb;

import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.internal.jaxb.gco.PropertyType;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.internal.xml.LegacyNamespaces;
import org.apache.sis.util.CorruptedObjectException;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Version;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.ReferenceResolver;
import org.apache.sis.xml.ValueConverter;

public final class Context
extends MarshalContext {
    public static final int MARSHALLING = 1;
    public static final int SUBSTITUTE_LANGUAGE = 2;
    public static final int SUBSTITUTE_COUNTRY = 4;
    public static final int SUBSTITUTE_FILENAME = 8;
    public static final int SUBSTITUTE_MIMETYPE = 16;
    public static final int LEGACY_METADATA = 32;
    public static final int LENIENT_UNMARSHAL = 64;
    private static final int CLEAR_SEMAPHORE = 128;
    private static final ThreadLocal<Context> CURRENT = new ThreadLocal();
    public static final Logger LOGGER = Logging.getLogger((String)"org.apache.sis.xml");
    final int bitMasks;
    private final Deque<Locale> locales;
    private final TimeZone timezone;
    private final Map<String, String> schemas;
    private final Version versionGML;
    private final ReferenceResolver resolver;
    private final ValueConverter converter;
    private final Map<String, Object> identifiers;
    private final Map<Object, String> identifiedObjects;
    private final Filter logFilter;
    private PropertyType<?, ?> wrapper;
    private final Context previous;

    public Context(int n, Locale locale, TimeZone timeZone, Map<String, String> map, Version version, Version version2, ReferenceResolver referenceResolver, ValueConverter valueConverter, Filter filter) {
        if (version2 != null && version2.compareTo(LegacyNamespaces.VERSION_2014) < 0) {
            n |= 0x20;
        }
        this.locales = new LinkedList<Locale>();
        this.timezone = timeZone;
        this.schemas = map;
        this.versionGML = version;
        this.resolver = referenceResolver;
        this.converter = valueConverter;
        this.logFilter = filter;
        this.identifiers = new HashMap<String, Object>();
        this.identifiedObjects = new IdentityHashMap<Object, String>();
        if (locale != null) {
            this.locales.add(locale);
        }
        this.previous = CURRENT.get();
        if ((n & 1) != 0 && !Semaphores.queryAndSet((int)1)) {
            n |= 0x80;
        }
        this.bitMasks = n;
        CURRENT.set(this);
    }

    @Override
    public final Locale getLocale() {
        return this.locales.peekLast();
    }

    @Override
    public final TimeZone getTimeZone() {
        return this.timezone;
    }

    @Override
    public final Version getVersion(String string) {
        switch (string) {
            case "gml": {
                return this.versionGML;
            }
            case "gmd": {
                if ((this.bitMasks & 1) == 0) break;
                return (this.bitMasks & 0x20) == 0 ? LegacyNamespaces.VERSION_2016 : LegacyNamespaces.VERSION_2007;
            }
        }
        return null;
    }

    public static Context current() {
        return CURRENT.get();
    }

    public static void push(Locale locale) {
        Context context = Context.current();
        if (context != null) {
            if (locale == null) {
                locale = context.getLocale();
            }
            context.locales.addLast(locale);
        }
    }

    public static void pull() {
        Context context = Context.current();
        if (context != null) {
            context.locales.removeLast();
        }
    }

    public static boolean isFlagSet(Context context, int n) {
        return context != null && (context.bitMasks & n) != 0;
    }

    public static boolean isGMLVersion(Context context, Version version) {
        Version version2;
        if (context != null && (version2 = context.versionGML) != null) {
            return version2.compareTo(version) >= 0;
        }
        return true;
    }

    public static StringBuilder schema(Context context, String string, String string2) {
        String string3;
        Map<String, String> map;
        StringBuilder stringBuilder = new StringBuilder(128);
        if (context != null && (map = context.schemas) != null && (string3 = map.get(string)) != null) {
            string2 = string3;
        }
        stringBuilder.append(string2);
        int n = stringBuilder.length();
        if (n != 0 && stringBuilder.charAt(n - 1) != '/') {
            stringBuilder.append('/');
        }
        return stringBuilder;
    }

    public static PropertyType<?, ?> getWrapper(Context context) {
        return context != null ? context.wrapper : null;
    }

    public static void setWrapper(Context context, PropertyType<?, ?> propertyType) {
        if (context != null) {
            context.wrapper = propertyType;
        }
    }

    public static String getObjectID(Context context, Object object) {
        return context != null ? context.identifiedObjects.get(object) : null;
    }

    public static Object getObjectForID(Context context, String string) {
        return context != null ? context.identifiers.get(string) : null;
    }

    public static boolean setObjectForID(Context context, Object object, String string) {
        if (context != null) {
            Object object2 = context.identifiers.putIfAbsent(string, object);
            if (object2 != null) {
                return object2 == object;
            }
            if (context.identifiedObjects.put(object, string) != null) {
                throw new CorruptedObjectException(string);
            }
        }
        return true;
    }

    public static ReferenceResolver resolver(Context context) {
        ReferenceResolver referenceResolver;
        if (context != null && (referenceResolver = context.resolver) != null) {
            return referenceResolver;
        }
        return ReferenceResolver.DEFAULT;
    }

    public static ValueConverter converter(Context context) {
        ValueConverter valueConverter;
        if (context != null && (valueConverter = context.converter) != null) {
            return valueConverter;
        }
        return ValueConverter.DEFAULT;
    }

    public static void warningOccured(Context context, Level level, Class<?> clazz, String string, Throwable throwable, Class<? extends IndexedResourceBundle> clazz2, short s, Object ... objectArray) {
        LogRecord logRecord;
        Object object;
        Locale locale;
        Locale locale2 = locale = context != null ? context.getLocale() : null;
        if (clazz2 != null) {
            if (clazz2 == Errors.class) {
                object = Errors.getResources((Locale)locale);
            } else if (clazz2 == Messages.class) {
                object = Messages.getResources((Locale)locale);
            } else {
                throw new IllegalArgumentException(String.valueOf(clazz2));
            }
            logRecord = object.getLogRecord(level, s, (Object)objectArray);
        } else {
            logRecord = new LogRecord(level, Exceptions.formatChainedMessages((Locale)locale, null, (Throwable)throwable));
        }
        logRecord.setSourceClassName(clazz.getCanonicalName());
        logRecord.setSourceMethodName(string);
        logRecord.setLoggerName("org.apache.sis.xml");
        if (context != null && (object = context.logFilter) != null) {
            logRecord.setThrown(throwable);
            if (!object.isLoggable(logRecord)) {
                return;
            }
        }
        LOGGER.log(logRecord);
    }

    public static void warningOccured(Context context, Class<?> clazz, String string, Class<? extends IndexedResourceBundle> clazz2, short s, Object ... objectArray) {
        Context.warningOccured(context, Level.WARNING, clazz, string, null, clazz2, s, objectArray);
    }

    public static void warningOccured(Context context, Class<?> clazz, String string, Exception exception, boolean bl) {
        Context.warningOccured(context, bl ? Level.WARNING : Level.FINE, clazz, string, exception, null, (short)0, (Object[])null);
    }

    public final void finish() {
        if ((this.bitMasks & 0x80) != 0) {
            Semaphores.clear((int)1);
        }
        if (this.previous != null) {
            CURRENT.set(this.previous);
        } else {
            CURRENT.remove();
        }
    }
}

