/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.measure.Unit;
import org.apache.sis.internal.geoapi.evolution.Interim;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.measure.Longitude;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Range;
import org.apache.sis.metadata.InvalidMetadataException;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Static;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.TransformException;
import org.opengis.temporal.TemporalPrimitive;

public final class Extents
extends Static {
    private GeographicBoundingBox bounds;
    private DefaultGeographicBoundingBox modifiable;
    public static final Extent WORLD;

    private Extents() {
    }

    public static GeographicBoundingBox getGeographicBoundingBox(Metadata metadata) {
        if (metadata == null) {
            return null;
        }
        Extents extents = new Extents();
        try {
            for (Identification identification : CollectionsExt.nonNull((Collection)metadata.getIdentificationInfo())) {
                if (!(identification instanceof DataIdentification)) continue;
                for (Extent extent : CollectionsExt.nonNull((Collection)((DataIdentification)identification).getExtents())) {
                    if (extent == null) continue;
                    extents.addHorizontal(extent);
                }
            }
        }
        catch (TransformException transformException) {
            throw new InvalidMetadataException(Errors.format((short)16), transformException);
        }
        return extents.bounds;
    }

    public static GeographicBoundingBox getGeographicBoundingBox(Extent extent) {
        if (extent == null) {
            return null;
        }
        Extents extents = new Extents();
        try {
            extents.addHorizontal(extent);
        }
        catch (TransformException transformException) {
            throw new InvalidMetadataException(Errors.format((short)16), transformException);
        }
        return extents.bounds;
    }

    private void addHorizontal(Extent extent) throws TransformException {
        Object object;
        boolean bl = false;
        ArrayList<Envelope> arrayList = new ArrayList<Envelope>();
        for (GeographicExtent geographicExtent : CollectionsExt.nonNull((Collection)extent.getGeographicElements())) {
            if (geographicExtent instanceof GeographicBoundingBox) {
                object = (GeographicBoundingBox)geographicExtent;
                if (this.bounds == null) {
                    if (!DefaultGeographicBoundingBox.getInclusion(object.getInclusion())) continue;
                    this.bounds = object;
                    continue;
                }
                if (this.bounds.equals(object)) continue;
                if (this.modifiable == null) {
                    this.modifiable = new DefaultGeographicBoundingBox(this.bounds);
                    this.bounds = this.modifiable;
                }
                this.modifiable.add((GeographicBoundingBox)object);
                continue;
            }
            if (this.bounds != null || !(geographicExtent instanceof BoundingPolygon) || Boolean.FALSE.equals(geographicExtent.getInclusion())) continue;
            for (Geometry geometry : CollectionsExt.nonNull((Collection)((BoundingPolygon)extent).getPolygons())) {
                CoordinateReferenceSystem coordinateReferenceSystem;
                Envelope envelope = Interim.getEnvelope(geometry);
                if (envelope == null || (coordinateReferenceSystem = envelope.getCoordinateReferenceSystem()) == null) continue;
                if (coordinateReferenceSystem instanceof GeographicCRS) {
                    if (!bl) {
                        bl = true;
                        arrayList.clear();
                    }
                } else if (bl) continue;
                arrayList.add(envelope);
            }
        }
        if (this.bounds == null) {
            for (Envelope envelope : arrayList) {
                object = new DefaultGeographicBoundingBox();
                ((DefaultGeographicBoundingBox)object).setBounds(envelope);
                if (this.bounds == null) {
                    this.modifiable = object;
                    this.bounds = this.modifiable;
                    continue;
                }
                this.modifiable.add((GeographicBoundingBox)object);
            }
        }
    }

    public static MeasurementRange<Double> getVerticalRange(Extent extent) {
        MeasurementRange measurementRange = null;
        VerticalDatumType verticalDatumType = null;
        if (extent != null) {
            for (VerticalExtent verticalExtent : CollectionsExt.nonNull((Collection)extent.getVerticalElements())) {
                VerticalDatum verticalDatum;
                double d = verticalExtent.getMinimumValue();
                double d2 = verticalExtent.getMaximumValue();
                VerticalCRS verticalCRS = verticalExtent.getVerticalCRS();
                VerticalDatumType verticalDatumType2 = null;
                Unit unit = null;
                if (verticalCRS != null) {
                    verticalDatum = verticalCRS.getDatum();
                    if (verticalDatum != null && VerticalDatumType.DEPTH.equals((Object)(verticalDatumType2 = verticalDatum.getVerticalDatumType()))) {
                        verticalDatumType2 = VerticalDatumType.GEOIDAL;
                    }
                    CoordinateSystemAxis coordinateSystemAxis = verticalCRS.getCoordinateSystem().getAxis(0);
                    unit = coordinateSystemAxis.getUnit();
                    if (AxisDirection.DOWN.equals((Object)coordinateSystemAxis.getDirection())) {
                        double d3 = d;
                        d = -d2;
                        d2 = -d3;
                    }
                }
                if (measurementRange != null) {
                    if (verticalDatumType2 == null || unit == null) continue;
                    if (!verticalDatumType2.equals(verticalDatumType)) {
                        if (!verticalDatumType2.equals((Object)VerticalDatumType.GEOIDAL)) {
                            continue;
                        }
                    } else if (verticalDatumType != null && (verticalDatum = measurementRange.unit()) != null) {
                        if (!verticalDatum.isCompatible(unit)) continue;
                        measurementRange = (MeasurementRange)measurementRange.union((Range)MeasurementRange.create((double)d, (boolean)true, (double)d2, (boolean)true, (Unit)unit));
                        continue;
                    }
                }
                measurementRange = MeasurementRange.create((double)d, (boolean)true, (double)d2, (boolean)true, unit);
                verticalDatumType = verticalDatumType2;
            }
        }
        return measurementRange;
    }

    public static Range<Date> getTimeRange(Extent extent) {
        Date date = null;
        Date date2 = null;
        if (extent != null) {
            for (TemporalExtent temporalExtent : CollectionsExt.nonNull((Collection)extent.getTemporalElements())) {
                Date date3;
                Date date4;
                DefaultTemporalExtent defaultTemporalExtent;
                if (temporalExtent instanceof DefaultTemporalExtent) {
                    defaultTemporalExtent = (DefaultTemporalExtent)temporalExtent;
                    date4 = defaultTemporalExtent.getStartTime();
                    date3 = defaultTemporalExtent.getEndTime();
                } else {
                    defaultTemporalExtent = temporalExtent.getExtent();
                    date4 = DefaultTemporalExtent.getTime((TemporalPrimitive)defaultTemporalExtent, true);
                    date3 = DefaultTemporalExtent.getTime((TemporalPrimitive)defaultTemporalExtent, false);
                }
                if (date4 != null && (date == null || date4.before(date))) {
                    date = date4;
                }
                if (date3 == null || date2 != null && !date3.after(date2)) continue;
                date2 = date3;
            }
        }
        if (date == null && date2 == null) {
            return null;
        }
        return new Range(Date.class, date, true, date2, true);
    }

    public static Date getDate(Extent extent, double d) {
        ArgumentChecks.ensureFinite((String)"location", (double)d);
        Date date = null;
        Date date2 = null;
        if (extent != null) {
            for (TemporalExtent temporalExtent : CollectionsExt.nonNull((Collection)extent.getTemporalElements())) {
                DefaultTemporalExtent defaultTemporalExtent;
                Date date3 = null;
                Date date4 = null;
                if (temporalExtent instanceof DefaultTemporalExtent) {
                    defaultTemporalExtent = (DefaultTemporalExtent)temporalExtent;
                    if (d != 1.0) {
                        date3 = defaultTemporalExtent.getStartTime();
                    }
                    if (d != 0.0) {
                        date4 = defaultTemporalExtent.getEndTime();
                    }
                } else {
                    defaultTemporalExtent = temporalExtent.getExtent();
                    if (d != 1.0) {
                        date3 = DefaultTemporalExtent.getTime((TemporalPrimitive)defaultTemporalExtent, true);
                    }
                    if (d != 0.0) {
                        date4 = DefaultTemporalExtent.getTime((TemporalPrimitive)defaultTemporalExtent, false);
                    }
                }
                if (date3 != null && (date == null || date3.before(date))) {
                    date = date3;
                }
                if (date4 == null || date2 != null && !date4.after(date2)) continue;
                date2 = date4;
            }
        }
        if (date == null) {
            return date2;
        }
        if (date2 == null) {
            return date;
        }
        long l = date.getTime();
        return new Date(Math.addExact(l, Math.round((double)(date2.getTime() - l) * d)));
    }

    public static String getDescription(Extent extent, Locale locale) {
        return extent != null ? Types.toString(extent.getDescription(), locale) : null;
    }

    public static DirectPosition centroid(GeographicBoundingBox geographicBoundingBox) {
        if (geographicBoundingBox != null) {
            double d = (geographicBoundingBox.getNorthBoundLatitude() + geographicBoundingBox.getSouthBoundLatitude()) / 2.0;
            double d2 = geographicBoundingBox.getWestBoundLongitude();
            double d3 = geographicBoundingBox.getEastBoundLongitude();
            if (d3 < d2) {
                d3 += 360.0;
            }
            if (Double.isFinite(d2 = Longitude.normalize((double)((d2 + d3) / 2.0))) || Double.isFinite(d)) {
                return ReferencingServices.getInstance().geographic(d2, d);
            }
        }
        return null;
    }

    public static double area(GeographicBoundingBox geographicBoundingBox) {
        if (geographicBoundingBox == null) {
            return Double.NaN;
        }
        double d = geographicBoundingBox.getEastBoundLongitude() - geographicBoundingBox.getWestBoundLongitude();
        if (d > 360.0) {
            d = 360.0;
        } else if (d < 0.0) {
            d = d < -360.0 ? -360.0 : (d += 360.0);
        }
        return 4.0589730194049E13 * Math.toRadians(d) * Math.max(0.0, Math.sin(Math.toRadians(geographicBoundingBox.getNorthBoundLatitude())) - Math.sin(Math.toRadians(geographicBoundingBox.getSouthBoundLatitude())));
    }

    public static GeographicBoundingBox union(GeographicBoundingBox geographicBoundingBox, GeographicBoundingBox geographicBoundingBox2) {
        return Extents.apply(geographicBoundingBox, geographicBoundingBox2, DefaultGeographicBoundingBox::new, DefaultGeographicBoundingBox::add);
    }

    public static GeographicBoundingBox intersection(GeographicBoundingBox geographicBoundingBox, GeographicBoundingBox geographicBoundingBox2) {
        return Extents.apply(geographicBoundingBox, geographicBoundingBox2, DefaultGeographicBoundingBox::new, DefaultGeographicBoundingBox::intersect);
    }

    static GeographicExtent intersection(GeographicExtent geographicExtent, GeographicExtent geographicExtent2) {
        return Extents.intersection(geographicExtent instanceof GeographicBoundingBox ? (GeographicBoundingBox)geographicExtent : null, geographicExtent2 instanceof GeographicBoundingBox ? (GeographicBoundingBox)geographicExtent2 : null);
    }

    public static VerticalExtent intersection(VerticalExtent verticalExtent, VerticalExtent verticalExtent2) {
        return Extents.apply(verticalExtent, verticalExtent2, DefaultVerticalExtent::new, DefaultVerticalExtent::intersect);
    }

    public static TemporalExtent intersection(TemporalExtent temporalExtent, TemporalExtent temporalExtent2) {
        return Extents.apply(temporalExtent, temporalExtent2, DefaultTemporalExtent::new, DefaultTemporalExtent::intersect);
    }

    public static Extent intersection(Extent extent, Extent extent2) {
        return Extents.apply(extent, extent2, DefaultExtent::new, DefaultExtent::intersect);
    }

    private static <I, C extends ISOMetadata> I apply(I i, I i2, Function<I, C> function, BiConsumer<C, I> biConsumer) {
        if (i == null) {
            return i2;
        }
        if (i2 == null || i2 == i) {
            return i;
        }
        ISOMetadata iSOMetadata = (ISOMetadata)function.apply(i);
        biConsumer.accept(iSOMetadata, i2);
        if (iSOMetadata.equals(i, ComparisonMode.BY_CONTRACT)) {
            return i;
        }
        if (iSOMetadata.equals(i2, ComparisonMode.BY_CONTRACT)) {
            return i2;
        }
        return (I)iSOMetadata;
    }

    static {
        DefaultGeographicBoundingBox defaultGeographicBoundingBox = new DefaultGeographicBoundingBox(-180.0, 180.0, -90.0, 90.0);
        defaultGeographicBoundingBox.transitionTo(ModifiableMetadata.State.FINAL);
        DefaultExtent defaultExtent = new DefaultExtent((CharSequence)Vocabulary.formatInternational((short)225), defaultGeographicBoundingBox, null, null);
        defaultExtent.transitionTo(ModifiableMetadata.State.FINAL);
        WORLD = defaultExtent;
    }
}

