/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.xml.TransformingReader;

public final class Namespaces
extends Static {
    public static final String LAN = "http://standards.iso.org/iso/19115/-3/lan/1.0";
    public static final String GCO = "http://standards.iso.org/iso/19115/-3/gco/1.0";
    public static final String MCC = "http://standards.iso.org/iso/19115/-3/mcc/1.0";
    public static final String FCC = "http://standards.iso.org/iso/19110/fcc/1.0";
    public static final String GFC = "http://standards.iso.org/iso/19110/gfc/1.1";
    public static final String CAT = "http://standards.iso.org/iso/19115/-3/cat/1.0";
    public static final String MDB = "http://standards.iso.org/iso/19115/-3/mdb/1.0";
    public static final String CIT = "http://standards.iso.org/iso/19115/-3/cit/1.0";
    public static final String GEX = "http://standards.iso.org/iso/19115/-3/gex/1.0";
    public static final String MRS = "http://standards.iso.org/iso/19115/-3/mrs/1.0";
    public static final String RCE = "http://standards.iso.org/iso/19111/rce/1.0";
    public static final String MSR = "http://standards.iso.org/iso/19115/-3/msr/1.0";
    public static final String MRC = "http://standards.iso.org/iso/19115/-3/mrc/1.0";
    public static final String MRI = "http://standards.iso.org/iso/19115/-3/mri/1.0";
    public static final String MRD = "http://standards.iso.org/iso/19115/-3/mrd/1.0";
    public static final String MDT = "http://standards.iso.org/iso/19115/-3/mdt/1.0";
    public static final String MCO = "http://standards.iso.org/iso/19115/-3/mco/1.0";
    public static final String MAC = "http://standards.iso.org/iso/19115/-3/mac/1.0";
    public static final String MRL = "http://standards.iso.org/iso/19115/-3/mrl/1.0";
    public static final String MMI = "http://standards.iso.org/iso/19115/-3/mmi/1.0";
    public static final String DQC = "http://standards.iso.org/iso/19157/-2/dqc/1.0";
    public static final String MDQ = "http://standards.iso.org/iso/19157/-2/mdq/1.0";
    public static final String MDS = "http://standards.iso.org/iso/19115/-3/mds/1.0";
    public static final String SRV = "http://standards.iso.org/iso/19115/-3/srv/2.0";
    public static final String MPC = "http://standards.iso.org/iso/19115/-3/mpc/1.0";
    public static final String MDA = "http://standards.iso.org/iso/19115/-3/mda/1.0";
    public static final String MAS = "http://standards.iso.org/iso/19115/-3/mas/1.0";
    public static final String MEX = "http://standards.iso.org/iso/19115/-3/mex/1.0";
    public static final String GCX = "http://standards.iso.org/iso/19115/-3/gcx/1.0";
    public static final String MD1 = "http://standards.iso.org/iso/19115/-3/md1/1.0";
    public static final String MD2 = "http://standards.iso.org/iso/19115/-3/md2/1.0";
    public static final String GMW = "http://standards.iso.org/iso/19115/-3/gmw/1.0";
    @Deprecated
    public static final String GMD = "http://www.isotc211.org/2005/gmd";
    public static final String GML = "http://www.opengis.net/gml/3.2";
    public static final String CSW = "http://www.opengis.net/cat/csw/3.0";
    public static final String XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XLINK = "http://www.w3.org/1999/xlink";
    private static final String[] GENERIC_URLS = new String[]{"http://standards.iso.org/iso/19115/-3/", "http://standards.iso.org/iso/19115/-2/", "http://standards.iso.org/iso/19157/-2/", "http://standards.iso.org/iso/19111/", "http://standards.iso.org/iso/19110/", "http://www.isotc211.org/2005/", "http://www.opengis.net/", "http://www.w3.org/1999/", "http://www.cnig.gouv.fr/2005/"};
    private static final Map<String, String> SPECIFIC_URLS;

    private Namespaces() {
    }

    public static String getPreferredPrefix(String string, String string2) {
        ArgumentChecks.ensureNonNull((String)"namespace", (Object)string);
        String string3 = SPECIFIC_URLS.get(string);
        if (string3 != null) {
            return string3;
        }
        string = string.toLowerCase(Locale.ROOT);
        for (String string4 : GENERIC_URLS) {
            if (!string.startsWith(string4)) continue;
            int n = string4.length();
            int n2 = string.indexOf(47, n);
            string3 = n2 >= 0 ? string.substring(n, n2) : string.substring(n);
            return string3;
        }
        return string2;
    }

    public static String guessForType(String string) {
        if (string != null && string.length() >= 3) {
            if (string.charAt(2) == '_') {
                switch (string.charAt(0) << 16 | string.charAt(1)) {
                    case 4390985: {
                        return CIT;
                    }
                    case 4522072: {
                        return GEX;
                    }
                    case 4587587: {
                        return GFC;
                    }
                    case 4980805: 
                    case 4980809: {
                        return MRL;
                    }
                    case 4456531: 
                    case 0x4D0044: 
                    case 5046345: {
                        return TransformingReader.namespace(string);
                    }
                    case 5046360: {
                        return MDT;
                    }
                    case 0x500054: {
                        return LAN;
                    }
                    case 5439574: {
                        return SRV;
                    }
                    case 0x430044: 
                    case 4390995: 
                    case 5439555: {
                        return GML;
                    }
                }
            } else {
                return TransformingReader.namespace(string);
            }
        }
        return null;
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>(40);
        hashMap.put("http://www.w3.org/2001/XMLSchema", "xs");
        hashMap.put(XSI, "xsi");
        hashMap.put("http://www.w3.org/2004/02/skos/core#", "skos");
        hashMap.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        hashMap.put("http://www.w3.org/1998/Math/MathML", "mml");
        hashMap.put("http://www.opengis.net/sensorML/1.0", "sml1");
        hashMap.put("http://www.opengis.net/sensorML/1.0.1", "sml");
        hashMap.put("http://www.opengis.net/swe/1.0", "swe1");
        hashMap.put(CSW, "csw");
        hashMap.put("http://www.opengis.net/cat/csw/2.0.2", "csw2");
        hashMap.put("http://www.opengis.net/ows/2.0", "ows");
        hashMap.put("http://www.opengis.net/cat/wrs/1.0", "wrs");
        hashMap.put("http://www.opengis.net/cat/wrs", "wrs09");
        hashMap.put("http://www.opengis.net/ows-6/utds/0.3", "utds");
        hashMap.put("http://www.opengis.net/citygml/1.0", "core");
        hashMap.put("http://www.opengis.net/citygml/building/1.0", "build");
        hashMap.put("http://www.opengis.net/citygml/cityfurniture/1.0", "furniture");
        hashMap.put("http://www.opengis.net/citygml/transportation/1.0", "tr");
        hashMap.put("http://www.isotc211.org/2005/gco", "gcol");
        hashMap.put("http://www.isotc211.org/2005/srv", "srv1");
        hashMap.put("http://www.purl.org/dc/elements/1.1/", "dc2");
        hashMap.put("http://www.purl.org/dc/terms/", "dct2");
        hashMap.put("http://purl.org/dc/terms/", "dct");
        hashMap.put("http://www.inspire.org", "ins");
        hashMap.put("http://inspira.europa.eu/networkservice/view/1.0", "inspire_vs");
        hashMap.put("urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", "xal");
        hashMap.put("urn:oasis:names:tc:ebxml-regrep:xsd:rim:3.0", "rim");
        hashMap.put("urn:oasis:names:tc:ebxml-regrep:rim:xsd:2.5", "rim25");
        hashMap.put("urn:oasis:names:tc:xacml:2.0:context:schema:os", "xacml-context");
        hashMap.put("urn:oasis:names:tc:xacml:2.0:policy:schema:os", "xacml-policy");
        hashMap.put("urn:us:gov:ic:ism:v2", "icism");
        SPECIFIC_URLS = hashMap;
    }
}

