/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import org.exoplatform.ecm.webui.component.explorer.optionblocks.UIOptionBlockPanel;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIDocumentForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UISelectDocumentForm;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

@ComponentConfig(template="app:/groovy/webui/component/explorer/UIDocumentFormController.gtmpl")
public class UIDocumentFormController
extends UIContainer
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getLogger((String)UIDocumentFormController.class.getName());
    private NodeLocation currentNode_;
    private String repository_;
    private String OPTION_BLOCK_EXTENSION_TYPE = "org.exoplatform.ecm.dms.UIOptionBlockPanel";
    private List<UIComponent> listExtenstion = new ArrayList<UIComponent>();
    private boolean isDisplayOptionPanel = false;

    public UIDocumentFormController() throws Exception {
        this.addChild(UISelectDocumentForm.class, null, null);
        UIDocumentForm uiDocumentForm = (UIDocumentForm)this.createUIComponent(UIDocumentForm.class, null, null);
        uiDocumentForm.addNew(true);
        uiDocumentForm.setShowActionsOnTop(true);
        this.addChild((UIComponent)uiDocumentForm);
        uiDocumentForm.setRendered(false);
    }

    public void setCurrentNode(Node node) {
        this.currentNode_ = NodeLocation.getNodeLocationByNode((Node)node);
    }

    public void setRepository(String repository) {
        this.repository_ = repository;
    }

    public void initPopup(UIComponent uiComp) throws Exception {
        this.removeChildById("PopupComponent");
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "PopupComponent");
        uiPopup.setShowMask(true);
        uiPopup.setUIComponent(uiComp);
        uiPopup.setWindowSize(640, 300);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    public List<String> getListFileType() throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return templateService.getCreationableContentTypes(NodeLocation.getNodeByLocation((NodeLocation)this.currentNode_));
    }

    public void bindContentType() throws Exception {
        Comparator<String> ascComparator = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareTo(s2);
            }
        };
        TreeMap<String, String> templates = new TreeMap<String, String>(ascComparator);
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List acceptableContentTypes = templateService.getCreationableContentTypes(NodeLocation.getNodeByLocation((NodeLocation)this.currentNode_));
        if (acceptableContentTypes.size() == 0) {
            return;
        }
        String userName = Util.getPortalRequestContext().getRemoteUser();
        for (String contentType : acceptableContentTypes) {
            try {
                String label = templateService.getTemplateLabel(contentType);
                String templatePath = templateService.getTemplatePathByUser(true, contentType, userName);
                if (templatePath == null || templatePath.length() <= 0) continue;
                templates.put(label, contentType);
            }
            catch (AccessControlException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.warn((Object)(userName + " do not have sufficient permission to access " + contentType + " template."));
            }
            catch (PathNotFoundException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Node type template %s does not exist!", new Object[]{contentType});
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)e.getMessage());
            }
        }
        if (templates.size() > 0) {
            UISelectDocumentForm uiSelectForm = (UISelectDocumentForm)this.getChild(UISelectDocumentForm.class);
            if (templates.size() > 1) {
                uiSelectForm.setDocumentTemplates(templates);
            } else {
                UIDocumentFormController uiDCFormController = (UIDocumentFormController)uiSelectForm.getParent();
                UIDocumentForm documentForm = (UIDocumentForm)uiDCFormController.getChild(UIDocumentForm.class);
                documentForm.addNew(true);
                documentForm.getChildren().clear();
                documentForm.resetInterceptors();
                documentForm.resetProperties();
                documentForm.setContentType((String)templates.values().iterator().next());
                documentForm.setCanChangeType(false);
                uiSelectForm.setRendered(false);
                documentForm.setRendered(true);
            }
        }
    }

    public void init() throws Exception {
        ((UIDocumentForm)this.getChild(UIDocumentForm.class)).setRepositoryName(this.repository_);
        ((UIDocumentForm)this.getChild(UIDocumentForm.class)).setWorkspace(this.currentNode_.getWorkspace());
        ((UIDocumentForm)this.getChild(UIDocumentForm.class)).setStoredPath(this.currentNode_.getPath());
        ((UIDocumentForm)this.getChild(UIDocumentForm.class)).resetProperties();
    }

    public void activate() {
    }

    public void deActivate() {
        block3: {
            try {
                UIDocumentForm uiDocumentForm = (UIDocumentForm)this.getChild(UIDocumentForm.class);
                if (uiDocumentForm != null) {
                    uiDocumentForm.releaseLock();
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error("Unexpected error!", new Object[]{e.getMessage()});
            }
        }
    }

    public <T extends UIComponent> T setRendered(boolean rendered) {
        UIComponent res;
        block3: {
            res = super.setRendered(rendered);
            if (!rendered) {
                try {
                    this.deActivate();
                }
                catch (Exception ex) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error((Object)"Unknown err:", (Throwable)ex);
                }
            }
        }
        return (T)res;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIPopupWindow uiPopup = (UIPopupWindow)this.getAncestorOfType(UIPopupWindow.class);
        if (uiPopup != null && !uiPopup.isShow()) {
            uiPopup.setShowMask(true);
            this.deActivate();
        }
        super.processRender(context);
    }

    public void addOptionBlockPanel() throws Exception {
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        List extensions = manager.getUIExtensions(this.OPTION_BLOCK_EXTENSION_TYPE);
        for (UIExtension extension : extensions) {
            UIComponent uicomp = manager.addUIExtension(extension, null, (UIContainer)this);
            uicomp.setRendered(false);
            this.listExtenstion.add(uicomp);
        }
    }

    public boolean isHasOptionBlockPanel() {
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        List extensions = manager.getUIExtensions(this.OPTION_BLOCK_EXTENSION_TYPE);
        return extensions != null;
    }

    public void setDisplayOptionBlockPanel(boolean display) {
        for (UIComponent uicomp : this.listExtenstion) {
            uicomp.setRendered(display);
        }
        this.isDisplayOptionPanel = display;
    }

    public boolean isDisplayOptionBlockPanel() {
        return this.isDisplayOptionPanel;
    }

    public void initOptionBlockPanel() throws Exception {
        if (this.isHasOptionBlockPanel()) {
            this.addOptionBlockPanel();
            UIOptionBlockPanel optionBlockPanel = (UIOptionBlockPanel)this.getChild(UIOptionBlockPanel.class);
            if (optionBlockPanel.isHasOptionBlockExtension()) {
                optionBlockPanel.addOptionBlockExtension();
                this.setDisplayOptionBlockPanel(true);
            }
        }
    }

    public String getClosingConfirmMsg(String key) {
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        return res.getString(key);
    }
}

