/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.connector.clouddrives;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.services.cms.clouddrives.CloudDriveService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/clouddrive/disconnect")
public class DisconnectRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger((String)DisconnectRestService.class.getName());
    private CloudDriveService cloudDriveService;

    public DisconnectRestService(CloudDriveService cloudDriveService) {
        this.cloudDriveService = cloudDriveService;
    }

    @DELETE
    @Produces(value={"application/json"})
    @Operation(summary="Disconnect From Cloud Drive", method="POST", description="Disconnect From Cloud Drive")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response disconnect(@Parameter(description="workspace", required=true) @QueryParam(value="workspace") String workspace, @Parameter(description="userEmail", required=true) @QueryParam(value="userEmail") String userEmail, @Parameter(description="providerId", required=true) @QueryParam(value="providerId") String providerId) {
        try {
            this.cloudDriveService.disconnectCloudDrive(workspace, userEmail, providerId);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error disconnecting from cloud drive", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

