/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration.cometd;

import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import org.cometd.annotation.Param;
import org.cometd.annotation.Service;
import org.cometd.annotation.Subscription;
import org.cometd.annotation.server.ServerAnnotationProcessor;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.eclipse.jetty.util.component.LifeCycle;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.cms.documents.DocumentEditor;
import org.exoplatform.services.cms.documents.DocumentEditorProvider;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.documents.exception.DocumentEditorProviderNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;
import org.picocontainer.Startable;

public class CometdDocumentsService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(CometdDocumentsService.class);
    public static final String CHANNEL_NAME = "/eXo/Application/documents/editor/";
    public static final String CHANNEL_NAME_PARAMS = "/eXo/Application/documents/editor/{fileId}";
    public static final String DOCUMENT_OPENED_EVENT = "DOCUMENT_OPENED";
    public static final String LAST_EDITOR_CLOSED_EVENT = "LAST_EDITOR_CLOSED";
    public static final String CURRENT_PROVIDER_INFO = "CURRENT_PROVIDER_INFO";
    public static final int MIN_THREADS = 2;
    public static final int MIN_MAX_THREADS = 4;
    public static final int THREAD_IDLE_TIME = 120;
    public static final int MAX_FACTOR = 20;
    public static final int QUEUE_FACTOR = 40;
    public static final String THREAD_PREFIX = "documents-comet-thread-";
    protected final EXoContinuationBayeux exoBayeux;
    protected final CometdService service;
    protected final ExecutorService eventsHandlers;
    protected final DocumentService documentService;
    protected final IdentityRegistry identityRegistry;
    protected final Authenticator authenticator;
    protected final ChannelSubscriptionListener subscriptionListener = new ChannelSubscriptionListener();
    protected final ClientChannelListener channelListener = new ClientChannelListener();
    protected final EditorsContext editorsContext = new EditorsContext();

    public CometdDocumentsService(EXoContinuationBayeux exoBayeux, DocumentService documentService, IdentityRegistry identityRegistry, Authenticator authenticator) {
        this.exoBayeux = exoBayeux;
        this.documentService = documentService;
        this.service = new CometdService();
        this.eventsHandlers = this.createThreadExecutor(THREAD_PREFIX, 20, 40);
        this.identityRegistry = identityRegistry;
        this.authenticator = authenticator;
    }

    public void start() {
        final AtomicReference processor = new AtomicReference();
        this.exoBayeux.addEventListener((EventListener)new LifeCycle.Listener(){

            public void lifeCycleStarted(LifeCycle event) {
                ServerAnnotationProcessor p = new ServerAnnotationProcessor((BayeuxServer)CometdDocumentsService.this.exoBayeux);
                processor.set(p);
                p.process((Object)CometdDocumentsService.this.service);
            }

            public void lifeCycleStopped(LifeCycle event) {
                ServerAnnotationProcessor p = (ServerAnnotationProcessor)processor.get();
                if (p != null) {
                    p.deprocess((Object)CometdDocumentsService.this.service);
                }
            }

            public void lifeCycleStarting(LifeCycle event) {
            }

            public void lifeCycleFailure(LifeCycle event, Throwable cause) {
            }

            public void lifeCycleStopping(LifeCycle event) {
            }
        });
        if (PropertyManager.isDevelopping()) {
            this.exoBayeux.addListener((BayeuxServer.BayeuxServerListener)new BayeuxServer.SessionListener(){

                public void sessionRemoved(ServerSession session, ServerMessage message, boolean timedout) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("sessionRemoved: " + session.getId() + " timedout:" + timedout + " channels: " + CometdDocumentsService.this.channelsAsString(session.getSubscriptions())));
                    }
                }

                public void sessionAdded(ServerSession session, ServerMessage message) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("sessionAdded: " + session.getId() + " channels: " + CometdDocumentsService.this.channelsAsString(session.getSubscriptions())));
                    }
                }
            });
        }
    }

    protected String channelsAsString(Set<ServerChannel> channels) {
        return channels.stream().map(c -> c.getId()).collect(Collectors.joining(", "));
    }

    public void stop() {
    }

    public String getCometdServerPath() {
        return "/" + this.exoBayeux.getCometdContextName() + "/cometd";
    }

    public String getUserToken(String userId) {
        return this.exoBayeux.getUserToken(userId);
    }

    protected String asString(Object obj) {
        if (obj != null && String.class.isAssignableFrom(obj.getClass())) {
            return (String)String.class.cast(obj);
        }
        return null;
    }

    protected ExecutorService createThreadExecutor(String threadNamePrefix, int maxFactor, int queueFactor) {
        int cpus = Runtime.getRuntime().availableProcessors();
        int poolThreads = cpus / 4;
        poolThreads = poolThreads < 2 ? 2 : poolThreads;
        int maxThreads = Math.round((float)cpus * 1.0f * (float)maxFactor);
        maxThreads = maxThreads > 0 ? maxThreads : 1;
        maxThreads = maxThreads < 4 ? 4 : maxThreads;
        int queueSize = cpus * queueFactor;
        int n = queueSize = queueSize < queueFactor ? queueFactor : queueSize;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating thread executor " + threadNamePrefix + "* for " + poolThreads + ".." + maxThreads + " threads, queue size " + queueSize));
        }
        return new ThreadPoolExecutor(poolThreads, maxThreads, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new CommandThreadFactory(threadNamePrefix), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    class ChannelSubscriptionListener
    implements ServerChannel.SubscriptionListener {
        ChannelSubscriptionListener() {
        }

        public void subscribed(ServerSession remote, ServerChannel channel, ServerMessage message) {
            String channelId = channel.getId();
            if (channelId.startsWith(CometdDocumentsService.CHANNEL_NAME)) {
                String sessionId = remote.getId();
                String exoClientId = CometdDocumentsService.this.asString(message.get((Object)"exoClientId"));
                String exoContainerName = CometdDocumentsService.this.asString(message.get((Object)"exoContainerName"));
                String provider = CometdDocumentsService.this.asString(message.get((Object)"provider"));
                String workspace = CometdDocumentsService.this.asString(message.get((Object)"workspace"));
                if (provider != null) {
                    String fileId = channelId.substring(channelId.lastIndexOf("/") + 1);
                    CometdDocumentsService.this.editorsContext.addClient(sessionId, fileId, provider, workspace);
                    CometdDocumentsService.this.editorsContext.cancelClosedEditorTimer(fileId, workspace, provider);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(">> Subscribed: provider: " + provider + ", session:" + sessionId + " (" + exoContainerName + "@" + exoClientId + "), channel:" + channelId));
                }
            }
        }

        public void unsubscribed(ServerSession session, ServerChannel channel, ServerMessage message) {
            String channelId = channel.getId();
            if (channelId.startsWith(CometdDocumentsService.CHANNEL_NAME)) {
                String sessionId = session.getId();
                String exoClientId = null;
                String exoContainerName = null;
                final ClientInfo removedClient = CometdDocumentsService.this.editorsContext.removeClient(sessionId);
                if (removedClient != null) {
                    final String fileId = removedClient.getFileId();
                    final String provider = removedClient.getProvider();
                    final String workspace = removedClient.getWorkspace();
                    if (CometdDocumentsService.this.editorsContext.getOpenedEditorsCount(fileId, provider) == 0) {
                        try {
                            DocumentEditorProvider editorProvider = CometdDocumentsService.this.documentService.getEditorProvider(provider);
                            Timer timer = new Timer();
                            timer.schedule(new TimerTask(){

                                @Override
                                public void run() {
                                    try {
                                        String currentProvider = CometdDocumentsService.this.documentService.getCurrentDocumentProvider(fileId, workspace);
                                        if (currentProvider != null) {
                                            CometdDocumentsService.this.service.setCurrentDocumentProvider(fileId, workspace, null);
                                            CometdDocumentsService.this.service.sendLastEditorClosedEvent(fileId, provider);
                                            if (LOG.isDebugEnabled()) {
                                                LOG.debug((Object)("Last editor closed. Provider" + provider + ", workspace: " + removedClient.getWorkspace() + ", fileId:" + fileId));
                                            }
                                        }
                                    }
                                    catch (RepositoryException e) {
                                        LOG.error((Object)("Cannot reset current editor provider for fileId: " + fileId + ", workspace: " + workspace), (Throwable)e);
                                    }
                                }
                            }, editorProvider.getEditingFinishedDelay());
                            CometdDocumentsService.this.editorsContext.saveClosedEditorTimer(fileId, workspace, provider, timer);
                        }
                        catch (DocumentEditorProviderNotFoundException e) {
                            LOG.error("Cannot find {} editor provider. {}", new Object[]{provider, e.getMessage()});
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(">> Unsubscribed: session:" + sessionId + " (" + exoContainerName + "@" + exoClientId + "), channel:" + channelId));
                }
            }
        }
    }

    class ClientChannelListener
    implements BayeuxServer.ChannelListener {
        ClientChannelListener() {
        }

        public void configureChannel(ConfigurableServerChannel channel) {
        }

        public void channelAdded(ServerChannel channel) {
            String channelId = channel.getId();
            if (channelId.startsWith(CometdDocumentsService.CHANNEL_NAME)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("> Channel added: " + channelId));
                }
                channel.addListener((ConfigurableServerChannel.ServerChannelListener)CometdDocumentsService.this.subscriptionListener);
            }
        }

        public void channelRemoved(String channelId) {
            if (channelId.startsWith(CometdDocumentsService.CHANNEL_NAME) && LOG.isDebugEnabled()) {
                LOG.debug((Object)("< Channel removed: " + channelId));
            }
        }
    }

    static class EditorsContext {
        private ConcurrentHashMap<String, ClientInfo> clients = new ConcurrentHashMap();
        private ConcurrentHashMap<String, Map<String, Integer>> providers = new ConcurrentHashMap();
        private ConcurrentHashMap<ClientInfo, Timer> closedEditorTimers = new ConcurrentHashMap();

        EditorsContext() {
        }

        public void addClient(String sessionId, String fileId, String provider, String workspace) {
            this.clients.put(sessionId, new ClientInfo(fileId, workspace, provider));
            this.providers.compute(fileId, (key, providers) -> {
                if (providers == null) {
                    HashMap<String, Integer> providersMap = new HashMap<String, Integer>();
                    providersMap.put(provider, 1);
                    return providersMap;
                }
                providers.compute(provider, (providerName, count) -> count == null ? 1 : count + 1);
                return providers;
            });
        }

        public ClientInfo removeClient(String sessionId) {
            ClientInfo clientInfo = this.clients.remove(sessionId);
            if (clientInfo != null) {
                Map<String, Integer> editors = this.providers.get(clientInfo.getFileId());
                editors.compute(clientInfo.getProvider(), (provider, count) -> count == null || count < 1 ? 0 : count - 1);
            }
            return clientInfo;
        }

        public int getOpenedEditorsCount(String fileId, String provider) {
            if (this.providers.containsKey(fileId)) {
                return this.providers.get(fileId).get(provider);
            }
            return 0;
        }

        public void cancelClosedEditorTimer(String fileId, String workspace, String provider) {
            ClientInfo clientInfo = new ClientInfo(fileId, workspace, provider);
            Timer timer = this.closedEditorTimers.get(clientInfo);
            if (timer != null) {
                timer.cancel();
                this.closedEditorTimers.remove(clientInfo);
            }
        }

        public void saveClosedEditorTimer(String fileId, String workspace, String provider, Timer timer) {
            ClientInfo clientInfo = new ClientInfo(fileId, workspace, provider);
            this.closedEditorTimers.put(clientInfo, timer);
        }
    }

    @Service(value="documents")
    public class CometdService {
        @Inject
        private BayeuxServer bayeux;
        @org.cometd.annotation.Session
        private LocalSession localSession;
        @org.cometd.annotation.Session
        private ServerSession serverSession;

        @PostConstruct
        public void postConstruct() {
            this.bayeux.addListener((BayeuxServer.BayeuxServerListener)CometdDocumentsService.this.channelListener);
        }

        @PreDestroy
        public void preDestroy() {
            this.bayeux.removeListener((BayeuxServer.BayeuxServerListener)CometdDocumentsService.this.channelListener);
        }

        @Subscription(value={"/eXo/Application/documents/editor/{fileId}"})
        public void subscribeDocuments(Message message, final @Param(value="fileId") String fileId) throws RepositoryException {
            Object objData = message.getData();
            if (!Map.class.isInstance(objData)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Couldn't get data as a map from event");
                }
                return;
            }
            Map data = message.getDataAsMap();
            String type = (String)data.get("type");
            if (type.equals(CometdDocumentsService.DOCUMENT_OPENED_EVENT)) {
                final String userId = (String)data.get("userId");
                final String workspace = (String)data.get("workspace");
                final String provider = (String)data.get("provider");
                CometdDocumentsService.this.eventsHandlers.submit(new ContainerCommand(PortalContainer.getCurrentPortalContainerName()){

                    @Override
                    void onContainerError(String error) {
                        LOG.error("An error has occured in container: {}", new Object[]{this.containerName});
                    }

                    @Override
                    void execute(ExoContainer exoContainer) {
                        try {
                            DocumentEditorProvider editorProvider = CometdDocumentsService.this.documentService.getEditorProvider(provider);
                            Identity identity = CometdService.this.userIdentity(userId);
                            boolean allowed = editorProvider.isAvailableForUser(identity);
                            List<String> availableProviders = CometdDocumentsService.this.service.getAllAvailableProviders(identity);
                            String currentProvider = CometdDocumentsService.this.documentService.getCurrentDocumentProvider(fileId, workspace);
                            boolean available = allowed && (currentProvider == null || provider.equals(currentProvider));
                            CometdDocumentsService.this.service.sendCurrentProviderInfo(fileId, available, availableProviders);
                            if (currentProvider == null) {
                                CometdService.this.setCurrentDocumentProvider(fileId, workspace, provider);
                            }
                        }
                        catch (RepositoryException | DocumentEditorProviderNotFoundException e) {
                            LOG.error((Object)("Cannot send current provider info for fileId: " + fileId + ", workspace: " + workspace), e);
                        }
                    }
                });
            }
        }

        protected List<String> getAllAvailableProviders(Identity identity) {
            return CometdDocumentsService.this.documentService.getDocumentEditorProviders().stream().filter(provider -> provider.isAvailableForUser(identity)).map(DocumentEditor::getProviderName).collect(Collectors.toList());
        }

        protected void setCurrentDocumentProvider(final String fileId, final String workspace, final String provider) {
            CometdDocumentsService.this.eventsHandlers.submit(new ContainerCommand(PortalContainer.getCurrentPortalContainerName()){

                @Override
                void onContainerError(String error) {
                    LOG.error("An error has occured in container: {}", new Object[]{this.containerName});
                }

                @Override
                void execute(ExoContainer exoContainer) {
                    try {
                        CometdDocumentsService.this.documentService.saveCurrentDocumentProvider(fileId, workspace, provider);
                    }
                    catch (RepositoryException e) {
                        LOG.error((Object)("Cannot set current document provider for fileId: " + fileId + ", workspace: " + workspace), (Throwable)e);
                    }
                }
            });
        }

        protected Identity userIdentity(String userId) {
            Identity userIdentity = CometdDocumentsService.this.identityRegistry.getIdentity(userId);
            if (userIdentity == null) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("User identity not registered, trying to create it for: " + userId));
                    }
                    userIdentity = CometdDocumentsService.this.authenticator.createIdentity(userId);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Failed to create user identity: " + userId), (Throwable)e);
                }
            }
            return userIdentity;
        }

        protected void sendLastEditorClosedEvent(String fileId, String provider) {
            ServerChannel channel = this.bayeux.getChannel(CometdDocumentsService.CHANNEL_NAME + fileId);
            if (channel != null) {
                StringBuilder data = new StringBuilder();
                data.append('{');
                data.append("\"type\": \"");
                data.append(CometdDocumentsService.LAST_EDITOR_CLOSED_EVENT);
                data.append("\", ");
                data.append("\"fileId\": \"");
                data.append(fileId);
                data.append("\", ");
                data.append("\"provider\": \"");
                data.append(provider);
                data.append("\"}");
                channel.publish((Session)this.localSession, (Object)data.toString(), Promise.noop());
            }
        }

        protected void sendCurrentProviderInfo(String fileId, boolean available, List<String> availableProviders) {
            ServerChannel channel = this.bayeux.getChannel(CometdDocumentsService.CHANNEL_NAME + fileId);
            if (channel != null) {
                String allProviders = null;
                try {
                    allProviders = new JsonGeneratorImpl().createJsonArray(availableProviders).toString();
                }
                catch (JsonException e) {
                    LOG.warn((Object)"Cannot serialize all available providers to JSON", (Throwable)e);
                }
                StringBuilder data = new StringBuilder();
                data.append('{');
                data.append("\"type\": \"");
                data.append(CometdDocumentsService.CURRENT_PROVIDER_INFO);
                data.append("\", ");
                data.append("\"fileId\": \"");
                data.append(fileId);
                data.append("\", ");
                data.append("\"available\": \"");
                data.append(available);
                data.append("\", ");
                data.append("\"allProviders\":");
                data.append(allProviders);
                data.append("}");
                channel.publish((Session)this.localSession, (Object)data.toString(), Promise.noop());
            }
        }
    }

    static class CommandThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        CommandThreadFactory(String namePrefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = namePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L){

                protected void finalize() throws Throwable {
                    super.finalize();
                    threadNumber.decrementAndGet();
                }
            };
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    static class ClientInfo {
        private final String workspace;
        private final String provider;
        private final String fileId;

        public ClientInfo(String fileId, String workspace, String provider) {
            this.fileId = fileId;
            this.workspace = workspace;
            this.provider = provider;
        }

        public String getWorkspace() {
            return this.workspace;
        }

        public String getProvider() {
            return this.provider;
        }

        public String getFileId() {
            return this.fileId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fileId == null ? 0 : this.fileId.hashCode());
            result = 31 * result + (this.provider == null ? 0 : this.provider.hashCode());
            result = 31 * result + (this.workspace == null ? 0 : this.workspace.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClientInfo other = (ClientInfo)obj;
            if (this.fileId == null ? other.fileId != null : !this.fileId.equals(other.fileId)) {
                return false;
            }
            if (this.provider == null ? other.provider != null : !this.provider.equals(other.provider)) {
                return false;
            }
            return !(this.workspace == null ? other.workspace != null : !this.workspace.equals(other.workspace));
        }
    }

    abstract class ContainerCommand
    implements Runnable {
        final String containerName;

        ContainerCommand(String containerName) {
            this.containerName = containerName;
        }

        abstract void execute(ExoContainer var1);

        abstract void onContainerError(String var1);

        @Override
        public void run() {
            ExoContainer exoContainer = ExoContainerContext.getContainerByName((String)this.containerName);
            if (exoContainer != null) {
                ExoContainer contextContainer = ExoContainerContext.getCurrentContainerIfPresent();
                try {
                    ExoContainerContext.setCurrentContainer((ExoContainer)exoContainer);
                    RequestLifeCycle.begin((ExoContainer)exoContainer);
                    this.execute(exoContainer);
                }
                finally {
                    RequestLifeCycle.end();
                    ExoContainerContext.setCurrentContainer((ExoContainer)contextContainer);
                }
            } else {
                this.onContainerError("Container not found");
            }
        }
    }
}

