/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.esri;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.util.resources.Errors;

final class CharactersView
implements CharSequence {
    private static final char SPACE = ' ';
    final ChannelDataInput input;
    private final ByteBuffer buffer;
    private final byte[] array;
    private final boolean direct;

    CharactersView(ChannelDataInput channelDataInput, ByteBuffer byteBuffer) {
        this.input = channelDataInput;
        this.buffer = byteBuffer;
        this.direct = byteBuffer.hasArray();
        this.array = this.direct ? byteBuffer.array() : new byte[80];
    }

    @Override
    public int length() {
        return this.buffer.limit();
    }

    @Override
    public char charAt(int n) {
        return (char)Byte.toUnsignedInt(this.buffer.get(n));
    }

    final Map<String, String> readHeader() throws IOException, DataStoreContentException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (true) {
            String string;
            char c;
            if ((c = (string = this.readToken()).charAt(0)) != '#') {
                String string2;
                if (!Character.isJavaIdentifierStart(c)) {
                    this.buffer.position(this.buffer.position() - string.length() - 1);
                    return hashMap;
                }
                String string3 = null;
                while (!this.skipLine(true)) {
                    this.buffer.position(this.buffer.position() - 1);
                    string2 = this.readToken();
                    if (string3 == null) {
                        string3 = string2;
                        continue;
                    }
                    string3 = string3 + ' ' + string2;
                }
                string2 = hashMap.put(string = string.toUpperCase(Locale.US), string3);
                if (string2 != null && !string2.equals(string3)) {
                    if (string3 == null) {
                        hashMap.put(string, string2);
                    } else {
                        throw new DataStoreContentException(Errors.format((short)24, (Object)string));
                    }
                }
            }
            this.skipLine(false);
        }
    }

    private int readByte() throws IOException {
        if (!this.buffer.hasRemaining()) {
            if (this.input == null) {
                throw new EOFException();
            }
            this.input.ensureBufferContains(1);
        }
        return Byte.toUnsignedInt(this.buffer.get());
    }

    private boolean skipLine(boolean bl) throws IOException {
        int n;
        this.buffer.position(this.buffer.position() - 1);
        boolean bl2 = false;
        do {
            boolean bl3 = bl2 = (n = this.readByte()) == 13 || n == 10;
        } while (!bl2 && (!bl || n <= 32));
        return bl2;
    }

    final String readToken() throws IOException, DataStoreContentException {
        int n;
        while (this.readByte() <= 32) {
        }
        int n2 = this.buffer.position() - 1;
        do {
            if (this.buffer.hasRemaining()) continue;
            if (this.input == null) {
                throw new EOFException();
            }
            this.buffer.position(n2);
            int n3 = this.buffer.limit() - n2;
            if (n3 >= this.buffer.capacity()) {
                throw new DataStoreContentException(Resources.format((short)67, this.input.filename));
            }
            this.input.ensureBufferContains(n3 + 1);
            this.buffer.position(n3);
            n2 = 0;
        } while ((n = Byte.toUnsignedInt(this.buffer.get())) > 32);
        return this.subSequence(n2, this.buffer.position() - 1);
    }

    @Override
    public String subSequence(int n, int n2) {
        int n3 = n2 - n;
        if (this.direct) {
            return new String(this.array, n, n3, StandardCharsets.US_ASCII);
        }
        if (n3 <= this.array.length) {
            JDK9.get((ByteBuffer)this.buffer, (int)n, (byte[])this.array, (int)0, (int)n3);
            return new String(this.array, 0, n3, StandardCharsets.US_ASCII);
        }
        byte[] byArray = new byte[n3];
        JDK9.get((ByteBuffer)this.buffer, (int)n, (byte[])byArray);
        return new String(byArray, StandardCharsets.US_ASCII);
    }

    @Override
    public String toString() {
        return this.subSequence(0, this.length());
    }
}

