/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.image;

import java.awt.image.RenderedImage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.apache.sis.internal.storage.image.FormatFinder;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArraysExt;

enum FormatFilter {
    NAME(ImageReaderWriterSpi::getFormatNames),
    SUFFIX(ImageReaderWriterSpi::getFileSuffixes),
    MIME(ImageReaderWriterSpi::getMIMETypes);

    private final Function<ImageReaderWriterSpi, String[]> property;
    private static final Class<?>[] VALID_INPUTS;
    private static final Class<?>[] VALID_OUTPUTS;

    private FormatFilter(Function<ImageReaderWriterSpi, String[]> function) {
        this.property = function;
    }

    private <T extends ImageReaderWriterSpi> Iterator<T> getServiceProviders(Class<T> clazz, String string) {
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        if (string != null) {
            ServiceRegistry.Filter filter = object -> {
                Object[] objectArray = this.property.apply((ImageReaderWriterSpi)object);
                return ArraysExt.contains((Object[])objectArray, (Object)string);
            };
            return iIORegistry.getServiceProviders(clazz, filter, true);
        }
        return iIORegistry.getServiceProviders(clazz, true);
    }

    final ImageReaderSpi findProvider(String string, StorageConnector storageConnector, Set<ImageReaderSpi> set) throws IOException, DataStoreException {
        Iterator<ImageReaderSpi> iterator = SUFFIX.getServiceProviders(ImageReaderSpi.class, string);
        block0: while (iterator.hasNext()) {
            ImageReaderSpi imageReaderSpi = iterator.next();
            if (!set.add(imageReaderSpi)) continue;
            for (Class<?> clazz : imageReaderSpi.getInputTypes()) {
                Object obj;
                if (!ArraysExt.contains((Object[])VALID_INPUTS, clazz) || (obj = storageConnector.getStorageAs(clazz)) == null) continue;
                if (!imageReaderSpi.canDecodeInput(obj)) continue block0;
                return imageReaderSpi;
            }
        }
        return null;
    }

    final ImageReader createReader(String string, FormatFinder formatFinder, Map<ImageReaderSpi, Boolean> map) throws IOException, DataStoreException {
        Iterator<ImageReaderSpi> iterator = this.getServiceProviders(ImageReaderSpi.class, string);
        block0: while (iterator.hasNext()) {
            ImageReaderSpi imageReaderSpi = iterator.next();
            if (map.putIfAbsent(imageReaderSpi, Boolean.FALSE) != null) continue;
            for (Class<?> clazz : imageReaderSpi.getInputTypes()) {
                if (!ArraysExt.contains((Object[])VALID_INPUTS, clazz)) continue;
                Object obj = formatFinder.connector.getStorageAs(clazz);
                if (obj != null) {
                    if (!imageReaderSpi.canDecodeInput(obj)) continue block0;
                    ImageReader imageReader = imageReaderSpi.createReaderInstance();
                    imageReader.setInput(obj, false, true);
                    formatFinder.keepOpen = obj;
                    return imageReader;
                }
                if (clazz != ImageInputStream.class) continue;
                map.put(imageReaderSpi, Boolean.TRUE);
            }
        }
        return null;
    }

    final ImageWriter createWriter(String string, FormatFinder formatFinder, RenderedImage renderedImage, Map<ImageWriterSpi, Boolean> map) throws IOException, DataStoreException {
        Iterator<ImageWriterSpi> iterator = this.getServiceProviders(ImageWriterSpi.class, string);
        while (iterator.hasNext()) {
            ImageWriterSpi imageWriterSpi = iterator.next();
            if (map.putIfAbsent(imageWriterSpi, Boolean.FALSE) != null || renderedImage != null && !imageWriterSpi.canEncodeImage(renderedImage)) continue;
            for (Class<?> clazz : imageWriterSpi.getOutputTypes()) {
                Object obj;
                if (ArraysExt.contains((Object[])VALID_OUTPUTS, clazz) && (obj = formatFinder.connector.getStorageAs(clazz)) != null) {
                    ImageWriter imageWriter = imageWriterSpi.createWriterInstance();
                    imageWriter.setOutput(obj);
                    formatFinder.keepOpen = obj;
                    return imageWriter;
                }
                if (clazz != ImageOutputStream.class) continue;
                map.put(imageWriterSpi, Boolean.TRUE);
            }
        }
        return null;
    }

    static {
        VALID_INPUTS = new Class[]{ImageInputStream.class, DataInput.class, InputStream.class, File.class, Path.class, URL.class, URI.class};
        VALID_OUTPUTS = new Class[]{DataOutput.class, OutputStream.class, File.class, Path.class, URL.class, URI.class};
    }
}

