/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.wkt;

import java.text.ParseException;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.referencing.DefinitionVerifier;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.referencing.CRS;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArraysExt;
import org.opengis.geometry.Geometry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

public final class StoreFormat
extends WKTFormat {
    private final GeometryLibrary library;
    private final StoreListeners listeners;

    public StoreFormat(Locale locale, TimeZone timeZone, GeometryLibrary geometryLibrary, StoreListeners storeListeners) {
        super(locale, timeZone);
        this.library = geometryLibrary;
        this.listeners = storeListeners;
    }

    public Geometry parseGeometry(String string, String string2, String string3) {
        if (string != null) {
            try {
                GeometryWrapper geometryWrapper = Geometries.implementation((GeometryLibrary)this.library).parseWKT(string);
                geometryWrapper.setCoordinateReferenceSystem(this.parseCRS(string2, string3));
                return geometryWrapper;
            }
            catch (Exception exception) {
                this.log(exception);
            }
        }
        return null;
    }

    public CoordinateReferenceSystem parseCRS(String ... stringArray) {
        try {
            Object[] objectArray = new CoordinateReferenceSystem[stringArray.length];
            int n = 0;
            for (String string : stringArray) {
                if (string == null) continue;
                Object object = this.parseObject(string);
                this.validate(object);
                objectArray[n++] = (CoordinateReferenceSystem)object;
            }
            if (n != 0) {
                return CRS.compound((CoordinateReferenceSystem[])((CoordinateReferenceSystem[])ArraysExt.resize((Object[])objectArray, (int)n)));
            }
        }
        catch (ClassCastException | IllegalArgumentException | ParseException | FactoryException throwable) {
            this.log((Exception)throwable);
        }
        return null;
    }

    public void validate(Object object) {
        Warnings warnings = this.getWarnings();
        if (warnings != null) {
            this.log(new LogRecord(Level.WARNING, warnings.toString()));
        }
        if (object instanceof CoordinateReferenceSystem) {
            try {
                LogRecord logRecord;
                DefinitionVerifier definitionVerifier = DefinitionVerifier.withAuthority((CoordinateReferenceSystem)((CoordinateReferenceSystem)object), null, (boolean)false, (Locale)this.getLocale());
                if (definitionVerifier != null && (logRecord = definitionVerifier.warning(false)) != null) {
                    this.log(logRecord);
                }
            }
            catch (FactoryException factoryException) {
                this.listeners.warning((Exception)((Object)factoryException));
            }
        }
    }

    private void log(Exception exception) {
        this.listeners.warning(Resources.forLocale(this.listeners.getLocale()).getString((short)37, this.listeners.getSourceName()), exception);
    }

    private void log(LogRecord logRecord) {
        logRecord.setSourceClassName(this.listeners.getSource().getClass().getName());
        logRecord.setSourceMethodName("getMetadata");
        logRecord.setLoggerName("org.apache.sis.io.wkt");
        this.listeners.warning(logRecord);
    }
}

