/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Collection;
import java.util.Comparator;
import java.util.OptionalLong;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.internal.feature.FeatureUtilities;
import org.apache.sis.internal.geoapi.filter.SortBy;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.storage.AbstractFeatureSet;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureQuery;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.event.StoreListeners;

final class FeatureSubset
extends AbstractFeatureSet {
    private final FeatureSet source;
    private final FeatureQuery query;
    private DefaultFeatureType resultType;

    FeatureSubset(FeatureSet featureSet, FeatureQuery featureQuery) {
        super(featureSet instanceof StoreListeners ? (StoreListeners)((Object)featureSet) : null, false);
        this.source = featureSet;
        this.query = featureQuery;
    }

    @Override
    public synchronized DefaultFeatureType getType() throws DataStoreException {
        if (this.resultType == null) {
            DefaultFeatureType defaultFeatureType = this.source.getType();
            try {
                this.resultType = this.query.expectedType(defaultFeatureType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DataStoreContentException(Resources.forLocale(this.listeners.getLocale()).getString((short)55, defaultFeatureType.getName()), illegalArgumentException);
            }
        }
        return this.resultType;
    }

    @Override
    public Stream<AbstractFeature> features(boolean bl) throws DataStoreException {
        FeatureQuery.NamedExpression[] namedExpressionArray;
        OptionalLong optionalLong;
        long l;
        SortBy<AbstractFeature> sortBy;
        Stream<AbstractFeature> stream = this.source.features(bl);
        Filter<? super AbstractFeature> filter = this.query.getSelection();
        if (filter != null && !filter.equals((Object)Filter.include())) {
            stream = stream.filter((Predicate<AbstractFeature>)filter);
        }
        if ((sortBy = this.query.getSortBy()) != null) {
            stream = stream.sorted((Comparator<AbstractFeature>)sortBy);
        }
        if ((l = this.query.getOffset()) > 0L) {
            stream = stream.skip(l);
        }
        if ((optionalLong = this.query.getLimit()).isPresent()) {
            stream = stream.limit(optionalLong.getAsLong());
        }
        if ((namedExpressionArray = this.query.getProjection()) != null) {
            Expression[] expressionArray = new Expression[namedExpressionArray.length];
            for (int i = 0; i < expressionArray.length; ++i) {
                expressionArray[i] = namedExpressionArray[i].expression;
            }
            DefaultFeatureType defaultFeatureType = this.getType();
            String[] stringArray = FeatureUtilities.getNames((Collection)defaultFeatureType.getProperties(false));
            stream = stream.map(abstractFeature -> {
                AbstractFeature abstractFeature2 = defaultFeatureType.newInstance();
                for (int i = 0; i < expressionArray.length; ++i) {
                    abstractFeature2.setPropertyValue(stringArray[i], expressionArray[i].apply(abstractFeature));
                }
                return abstractFeature2;
            });
        }
        return stream;
    }
}

