/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cometd.oort.OortObject;

public class OortObjectMergers {
    private OortObjectMergers() {
    }

    public static OortObject.Merger<Long, Long> longSum() {
        return new LongSumMerger();
    }

    public static <K, V> OortObject.Merger<Map<K, V>, Map<K, V>> mapUnion() {
        return new MapUnionMerger();
    }

    public static <K, V> OortObject.Merger<ConcurrentMap<K, V>, ConcurrentMap<K, V>> concurrentMapUnion() {
        return new ConcurrentMapUnionMerger();
    }

    public static <E> OortObject.Merger<List<E>, List<E>> listUnion() {
        return new ListUnionMerger();
    }

    private static class LongSumMerger
    implements OortObject.Merger<Long, Long> {
        private LongSumMerger() {
        }

        @Override
        public Long merge(Collection<OortObject.Info<Long>> infos) {
            long sum = 0L;
            for (OortObject.Info<Long> info : infos) {
                sum += info.getObject().longValue();
            }
            return sum;
        }
    }

    private static class MapUnionMerger<K, V>
    implements OortObject.Merger<Map<K, V>, Map<K, V>> {
        private MapUnionMerger() {
        }

        @Override
        public Map<K, V> merge(Collection<OortObject.Info<Map<K, V>>> infos) {
            HashMap<K, V> result = new HashMap<K, V>();
            for (OortObject.Info<Map<K, V>> value : infos) {
                result.putAll(value.getObject());
            }
            return result;
        }
    }

    private static class ConcurrentMapUnionMerger<K, V>
    implements OortObject.Merger<ConcurrentMap<K, V>, ConcurrentMap<K, V>> {
        private ConcurrentMapUnionMerger() {
        }

        @Override
        public ConcurrentMap<K, V> merge(Collection<OortObject.Info<ConcurrentMap<K, V>>> infos) {
            ConcurrentHashMap result = new ConcurrentHashMap();
            for (OortObject.Info<ConcurrentMap<K, V>> value : infos) {
                result.putAll(value.getObject());
            }
            return result;
        }
    }

    public static class ListUnionMerger<E>
    implements OortObject.Merger<List<E>, List<E>> {
        @Override
        public List<E> merge(Collection<OortObject.Info<List<E>>> infos) {
            ArrayList result = new ArrayList();
            for (OortObject.Info<List<E>> value : infos) {
                result.addAll(value.getObject());
            }
            return result;
        }
    }
}

