/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import org.cometd.oort.Oort;
import org.cometd.oort.OortObject;
import org.cometd.oort.OortObjectFactories;
import org.cometd.oort.OortService;

public abstract class OortPrimaryService<R, C>
extends OortService<R, C> {
    private final boolean primary;
    private final OortObject<Boolean> nodes;

    public OortPrimaryService(Oort oort, String name, boolean primary) {
        super(oort, name);
        this.primary = primary;
        this.nodes = new OortObject<Boolean>(oort, name, OortObjectFactories.forBoolean(primary));
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public String getPrimaryOortURL() {
        OortObject.Info<Boolean> info = this.nodes.getInfoByObject(true);
        return info == null ? null : info.getOortURL();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.nodes.start();
    }

    @Override
    protected void doStop() throws Exception {
        this.nodes.stop();
        super.doStop();
    }
}

