/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.model.constant;

import java.io.Serializable;
import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;
import org.slf4j.helpers.MessageFormatter;

public enum PerkStoreError {
    GLOBAL_SETTINGS_ACCESS_DENIED("settings.access", "User {} isn't alowed to access global settings", 1),
    GLOBAL_SETTINGS_MODIFICATION_DENIED("settings.modification", "User {} isn't alowed to modify global settings", 1),
    PRODUCT_CREATION_DENIED("product.creation", "User {} isn't alowed to create a product", 1),
    PRODUCT_MODIFICATION_DENIED("product.modification", "User {} isn't alowed to modify product {}", 2),
    PRODUCT_NOT_EXISTS("product.existance", "Product with id {} doesn't exists", 1),
    ORDER_CREATION_DENIED("order.creation", "User {} isn't allowed to order on product {}", 2),
    ORDER_CREATION_STATUS_DENIED("order.creation", "Order status should be automatically created by internal process"),
    ORDER_CREATION_EMPTY_TX("order.creation", "Order transaction is mandatory"),
    ORDER_CREATION_EMPTY_QUANTITY("order.creation", "Order quantity should be positive"),
    ORDER_CREATION_EMPTY_AMOUNT("order.creation", "Order amount should be positive"),
    ORDER_CREATION_EMPTY_RECEIVER("order.creation", "Order receiver is mandatory"),
    ORDER_CREATION_EMPTY_SENDER("order.creation", "Order sender is mandatory"),
    ORDER_CREATION_QUANTITY_EXCEEDS_SUPPLY("order.creation", "Ordered quantity by user {} exceeds available supply.", 1),
    ORDER_CREATION_QUANTITY_EXCEEDS_ALLOWED("order.creation", "Ordered quantity by user {} exceeds allowed quantity per user.", 1),
    ORDER_MODIFICATION_DENIED("order.modification", "User {} isn't allowed to changed order on product '{}'", 2),
    ORDER_MODIFICATION_QUANTITY_INVALID_REMAINING("order.modification", "Remaining quantity to process {} isn't valid for order with id {}.", 2),
    ORDER_NOT_EXISTS("order.existance", "Order with id {} doesn't exists", 1),
    ORDER_CREATION_EMPTY_PRODUCT("order.creation", "Order product is mandatory"),
    PRODUCT_IS_DISABLED("product.disabled", "Product with {} is disabled", 1),
    PRODUCT_ACCESS_DENIED("product.access", "Denied access to product '{}' for user {}", 2),
    ORDER_ACCESS_DENIED("order.access", "Denied access to order with id {} for user {}", 2),
    ORDER_FRAUD_NOT_TOKEN_TRANSACTION("order.fraud", "A non token transaction has been injected in perk store as product order", 0),
    ORDER_FRAUD_WRONG_TOKEN_TRANSFER_METHOD("order.fraud", "A non 'transfer' token transaction has been injected in perk store as product order", 0),
    ORDER_FRAUD_WRONG_AMOUNT("order.fraud", "Product order amount sent is different from amount found on blockchain", 0),
    ORDER_FRAUD_WRONG_SENDER("order.fraud", "Product order transaction sender is incoherent with transaction sender on blockchain", 0),
    ORDER_FRAUD_WRONG_RECEIVER("order.fraud", "Product order transaction sender is incoherent with transaction receiver on blockchain", 0);

    private int code;
    private String suffix;
    private String description;
    private int descriptionParametersCount;

    private PerkStoreError(String errorSuffix, String description) {
        this(errorSuffix, description, 0);
    }

    private PerkStoreError(String errorSuffix, String description, int descriptionParametersCount) {
        if (StringUtils.isBlank((String)description)) {
            throw new IllegalArgumentException("Description is mandatory");
        }
        if (StringUtils.isBlank((String)errorSuffix)) {
            throw new IllegalArgumentException("Error suffix is mandatory");
        }
        this.code = this.ordinal() + 1;
        this.suffix = errorSuffix;
        this.description = description;
        this.descriptionParametersCount = descriptionParametersCount;
    }

    public String getErrorDescription(String message, boolean localizedMessage, Serializable ... parameters) {
        String descriptionDisplay;
        this.checkValidParametersCount(parameters);
        String string = descriptionDisplay = StringUtils.isBlank((String)message) ? this.description : message;
        if (this.descriptionParametersCount == 0) {
            return descriptionDisplay;
        }
        if (localizedMessage) {
            return MessageFormat.format(descriptionDisplay.replaceAll("'", "''"), parameters);
        }
        return MessageFormatter.arrayFormat((String)descriptionDisplay, (Object[])parameters).getMessage();
    }

    public String computeErrorMessage(String message, boolean localizedMessage, Serializable ... parameters) {
        if (localizedMessage) {
            return this.getErrorDescription(message, localizedMessage, parameters);
        }
        return this.getErrorCode().toUpperCase() + ": " + this.getErrorDescription(message, localizedMessage, parameters);
    }

    public String getErrorCode() {
        return (this.suffix == null ? "" : this.suffix) + "-" + this.code;
    }

    public void checkValidParametersCount(Serializable ... parameters) {
        if (parameters == null && this.descriptionParametersCount > 0 || parameters != null && parameters.length != this.descriptionParametersCount) {
            throw new IllegalArgumentException("Parameters count should be " + this.descriptionParametersCount);
        }
    }

    public int getCode() {
        return this.code;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

