/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayInputStream;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.exoplatform.perkstore.exception.PerkStoreException;
import org.exoplatform.perkstore.model.FileDetail;
import org.exoplatform.perkstore.model.Product;
import org.exoplatform.perkstore.service.PerkStoreService;
import org.exoplatform.perkstore.service.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.json.JSONObject;

@Path(value="/perkstore/api/product")
@Tag(name="/perkstore/api/product", description="Manages perk store products")
@RolesAllowed(value={"users"})
public class PerkStoreProductREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(PerkStoreProductREST.class);
    private PerkStoreService perkStoreService;

    public PerkStoreProductREST(PerkStoreService perkStoreService) {
        this.perkStoreService = perkStoreService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Creates or modifies a product", method="POST", description="Creates or modifies a product and returns the saved product")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveProduct(@RequestBody(description="Product object", required=true) Product product) {
        if (product == null) {
            LOG.warn((Object)"Bad request sent to server with empty product");
            return Response.status((int)400).build();
        }
        String currentUserId = Utils.getCurrentUserId();
        try {
            product = this.perkStoreService.saveProduct(product, currentUserId);
            product = this.perkStoreService.getProductById(product.getId(), currentUserId);
            return Response.ok((Object)product).build();
        }
        catch (PerkStoreException e) {
            return Utils.computeErrorResponse(LOG, e, "Saving product", currentUserId, product);
        }
        catch (Exception e) {
            LOG.error((Object)"Error saving product", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{productId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves a product by its id", method="GET", description="Retrieves a product by its id and returns the selected product if exists")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getProduct(@Parameter(description="Product technical id", required=true) @PathParam(value="productId") long productId) {
        if (productId == 0L) {
            LOG.warn((Object)"Bad request sent to server with empty productId");
            return Response.status((int)400).build();
        }
        String currentUserId = Utils.getCurrentUserId();
        try {
            Product product = this.perkStoreService.getProductById(productId, currentUserId);
            return Response.ok((Object)product).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting product", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get the list of product accessible by current user", method="GET", description="returns list of products")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response listProducts(@Parameter(description="Returning only the available products or all products") @Schema(defaultValue="false") @QueryParam(value="available") boolean available, @Parameter(description="Returning the number of Products or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) {
        String currentUserId = Utils.getCurrentUserId();
        try {
            List<Product> allProducts = this.perkStoreService.getProducts(available, currentUserId);
            if (returnSize) {
                JSONObject size = new JSONObject();
                size.put("size", allProducts.size());
                return Response.ok((Object)size.toString()).build();
            }
            return Response.ok(allProducts).build();
        }
        catch (PerkStoreException e) {
            return Utils.computeErrorResponse(LOG, e, "Getting products list", currentUserId, null);
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting products list", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="{productId}/image/{imageId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Get product image by its id", method="GET", description="returns image content of a product by its id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="304", description="Image not modified"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getProductImage(@Context Request request, @Parameter(description="Product technical id", required=true) @PathParam(value="productId") long productId, @Parameter(description="Image file technical id", required=true) @PathParam(value="imageId") long imageId) {
        String currentUserId = Utils.getCurrentUserId();
        try {
            FileDetail fileDetail = this.perkStoreService.getFileDetail(productId, imageId, false, currentUserId);
            if (fileDetail == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            long lastUpdated = fileDetail.getLastUpdated();
            EntityTag eTag = new EntityTag(String.valueOf(lastUpdated));
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                fileDetail = this.perkStoreService.getFileDetail(productId, imageId, true, currentUserId);
                ByteArrayInputStream stream = new ByteArrayInputStream(fileDetail.getData());
                builder = Response.ok((Object)stream, (String)"image/png");
                builder.tag(eTag);
            }
            CacheControl cc = new CacheControl();
            cc.setMaxAge(86400);
            builder.cacheControl(cc);
            return builder.cacheControl(cc).build();
        }
        catch (PerkStoreException e) {
            return Utils.computeErrorResponse(LOG, e, "Getting products list", currentUserId, null);
        }
        catch (Exception e) {
            LOG.warn("Error getting image {} on product {}", new Object[]{imageId, productId, e});
            return Response.serverError().build();
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="delete/{productId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves a product by its id", method="GET", description="returns selected product if exists")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteProduct(@Parameter(description="Product technical id", required=true) @PathParam(value="productId") long productId) {
        if (productId <= 0L) {
            LOG.warn((Object)"Bad request sent to server with empty productId");
            return Response.status((int)400).build();
        }
        String currentUserId = Utils.getCurrentUserId();
        try {
            this.perkStoreService.deleteProduct(productId, currentUserId);
            return Response.ok().build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((int)400).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((int)403).build();
        }
        catch (PerkStoreException e) {
            return Response.status((int)404).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error deleting product", (Throwable)e);
            return Response.status((int)500).build();
        }
    }
}

