/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.io.wkt.AbstractParser;
import org.apache.sis.io.wkt.StoredTree;
import org.apache.sis.io.wkt.UnparsableObjectException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Exceptions;
import org.opengis.referencing.cs.CoordinateSystem;

final class Element {
    private static final int NUMERIC = 1;
    private static final int TEMPORAL = 2;
    private static final String[] TIME_KEYWORDS = new String[]{"TimeOrigin", "TimeExtent"};
    final int offset;
    private byte keywordIndex;
    public final String keyword;
    private final boolean isEnumeration;
    final boolean isFragment;
    boolean isRoot;
    private final List<Object> children;
    private final Locale errorLocale;

    Element(Element element) {
        this.keyword = "<root>";
        this.offset = element.offset;
        this.errorLocale = element.errorLocale;
        this.isEnumeration = false;
        this.isFragment = false;
        this.children = new LinkedList<Object>();
        this.children.add(element);
        element.isRoot = true;
    }

    Element(String string, LinkedList<Object> linkedList, int n, Locale locale) {
        this.keyword = string;
        this.isEnumeration = linkedList == null;
        this.children = this.isEnumeration ? Collections.emptyList() : linkedList;
        this.isFragment = n < 0;
        this.offset = this.isFragment ? ~n : n;
        this.errorLocale = locale;
    }

    Element(AbstractParser abstractParser, String string, ParsePosition parsePosition) throws ParseException {
        int n;
        int n2;
        this.isFragment = false;
        this.errorLocale = abstractParser.errorLocale;
        this.offset = parsePosition.getIndex();
        int n3 = string.length();
        int n4 = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)this.offset, (int)n3);
        int n5 = n2 = n4 < n3 ? string.codePointAt(n4) : 0;
        if (!Character.isUnicodeIdentifierStart(n2)) {
            this.keyword = string;
            parsePosition.setErrorIndex(n4);
            throw this.unparsableString(string, parsePosition);
        }
        int n6 = n4;
        while ((n6 += Character.charCount(n2)) < n3 && Character.isUnicodeIdentifierPart(n2 = string.codePointAt(n6))) {
        }
        this.keyword = string.substring(n4, n6);
        n4 = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)n6, (int)n3);
        n2 = 0;
        if (n4 >= n3 || (n = abstractParser.symbols.matchingBracket(n6 = string.codePointAt(n4))) < 0) {
            parsePosition.setIndex(n4);
            this.children = Collections.emptyList();
            this.isEnumeration = true;
            return;
        }
        n4 = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)(n4 + Character.charCount(n6)), (int)n3);
        this.children = new LinkedList<Object>();
        this.isEnumeration = false;
        String string2 = abstractParser.symbols.trimmedSeparator();
        while (n4 < n3) {
            int n7;
            int n8 = string.codePointAt(n4);
            if (n8 == 36) {
                String string3;
                StoredTree storedTree;
                if ((storedTree = abstractParser.fragments.get(string3 = string.substring(n4--, n7 = AbstractParser.endOfFragmentName(string, ++n4)))) == null) {
                    parsePosition.setIndex(this.offset);
                    parsePosition.setErrorIndex(n4);
                    throw new UnparsableObjectException(this.errorLocale, 95, new Object[]{string3}, n4);
                }
                storedTree.toElements(abstractParser, this.children, ~n4);
                n4 = n7;
            } else if (Character.isUnicodeIdentifierStart(n8)) {
                if (n4 != (n4 = Element.regionMatches(string, n4, "true"))) {
                    this.children.add(Boolean.TRUE);
                } else if (n4 != (n4 = Element.regionMatches(string, n4, "false"))) {
                    this.children.add(Boolean.FALSE);
                } else {
                    parsePosition.setIndex(n4);
                    this.children.add(new Element(abstractParser, string, parsePosition));
                    n4 = parsePosition.getIndex();
                }
            } else {
                Object object;
                int n9 = abstractParser.symbols.matchingQuote(n8);
                if (n9 >= 0) {
                    int n10;
                    int n11 = Character.charCount(n9);
                    n4 += Character.charCount(n8) - n11;
                    CharSequence charSequence = null;
                    do {
                        if ((n10 = string.indexOf(n9, n4 += n11)) < n4) {
                            throw this.missingCharacter(n9, n4, parsePosition);
                        }
                        if (charSequence == null) {
                            charSequence = string.substring(n4, n10);
                            continue;
                        }
                        if (charSequence instanceof String) {
                            charSequence = new StringBuilder((String)charSequence);
                        }
                        ((StringBuilder)charSequence).appendCodePoint(n9).append(string, n4, n10);
                    } while ((n4 = n10 + n11) < string.length() && string.codePointAt(n4) == n9);
                    object = CharSequences.trimWhitespaces((CharSequence)charSequence).toString();
                } else {
                    parsePosition.setIndex(n4);
                    if (n2 == 0) {
                        n2 = ArraysExt.containsIgnoreCase((String[])TIME_KEYWORDS, (String)this.keyword) ? 2 : 1;
                    }
                    switch (n2) {
                        case 2: {
                            object = abstractParser.parseDate(string, parsePosition);
                            break;
                        }
                        case 1: {
                            object = abstractParser.parseNumber(string, parsePosition);
                            break;
                        }
                        default: {
                            throw new AssertionError(n2);
                        }
                    }
                    if (object == null) {
                        throw this.unparsableString(string, parsePosition);
                    }
                    n4 = parsePosition.getIndex();
                }
                this.children.add(object);
            }
            n4 = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)n4, (int)n3);
            if (string.startsWith(string2, n4)) {
                n4 = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)(n4 + string2.length()), (int)n3);
                continue;
            }
            if (n4 >= n3) break;
            n7 = string.codePointAt(n4);
            if (n7 == n) {
                parsePosition.setIndex(n4 + Character.charCount(n7));
                return;
            }
            parsePosition.setErrorIndex(n4);
            throw this.unparsableString(string, parsePosition);
        }
        throw this.missingCharacter(n, n4, parsePosition);
    }

    private static int regionMatches(String string, int n, String string2) {
        int n2;
        if (string.regionMatches(true, n, string2, 0, string2.length()) && ((n2 = n + string2.length()) >= string.length() || !Character.isUnicodeIdentifierPart(string.codePointAt(n2)))) {
            return n2;
        }
        return n;
    }

    final ParseException parseFailed(Exception exception) {
        return new UnparsableObjectException(this.errorLocale, 34, new String[]{this.keyword, Exceptions.getLocalizedMessage((Throwable)exception, (Locale)this.errorLocale)}, this.offset).initCause(exception);
    }

    private ParseException unparsableString(String string, ParsePosition parsePosition) {
        CharSequence[] charSequenceArray;
        short s;
        int n;
        int n2 = Math.max(this.offset, parsePosition.getErrorIndex());
        if (n2 >= (n = string.length())) {
            s = 138;
            charSequenceArray = new String[]{this.keyword};
        } else {
            s = 156;
            charSequenceArray = new CharSequence[]{this.keyword, CharSequences.token((CharSequence)string, (int)n2)};
        }
        parsePosition.setIndex(this.offset);
        return new UnparsableObjectException(this.errorLocale, s, charSequenceArray, n2);
    }

    private ParseException missingCharacter(int n, int n2, ParsePosition parsePosition) {
        parsePosition.setIndex(this.offset);
        parsePosition.setErrorIndex(n2);
        StringBuilder stringBuilder = new StringBuilder(2).appendCodePoint(n);
        return new UnparsableObjectException(this.errorLocale, 84, new CharSequence[]{this.keyword, stringBuilder}, n2);
    }

    final ParseException missingComponent(String string) {
        return new UnparsableObjectException(this.errorLocale, 85, new String[]{this.keyword, string}, this.offsetAfterKeyword());
    }

    /*
     * WARNING - void declaration
     */
    final ParseException missingOrUnknownComponent(String string) {
        void var4_8;
        short s;
        String string2 = null;
        for (Object objectArray2 : this.children) {
            if (objectArray2 instanceof Element && (string2 = ((Element)objectArray2).keyword) != null) break;
        }
        if (string2 != null) {
            s = 147;
            String[] stringArray = new String[]{string2};
        } else {
            s = 85;
            String[] stringArray = new String[]{this.keyword, string};
        }
        return new UnparsableObjectException(this.errorLocale, s, (Object[])var4_8, this.offset);
    }

    final ParseException illegalCS(CoordinateSystem coordinateSystem) {
        String string;
        short s;
        if (coordinateSystem == null) {
            s = 113;
            string = "coordinateSystem";
        } else {
            s = 51;
            string = coordinateSystem.getName().getCode();
        }
        return new UnparsableObjectException(this.errorLocale, s, new String[]{string}, this.offset);
    }

    private int offsetAfterKeyword() {
        if (this.isFragment) {
            return this.offset;
        }
        return this.offset + this.keyword.length();
    }

    public Object peekValue() {
        for (Object object : this.children) {
            if (object instanceof Element) continue;
            return object;
        }
        return null;
    }

    public Date pullDate(String string) throws ParseException {
        Iterator<Object> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Date)) continue;
            iterator.remove();
            return (Date)object;
        }
        throw this.missingComponent(string);
    }

    public double pullDouble(String string) throws ParseException {
        Iterator<Object> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Number)) continue;
            iterator.remove();
            return ((Number)object).doubleValue();
        }
        throw this.missingComponent(string);
    }

    public int pullInteger(String string) throws ParseException {
        Iterator<Object> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Number)) continue;
            iterator.remove();
            Number number = (Number)object;
            if (number instanceof Float || number instanceof Double) {
                throw new UnparsableObjectException(this.errorLocale, 154, new Object[]{Integer.class, number}, this.offset);
            }
            return number.intValue();
        }
        throw this.missingComponent(string);
    }

    public boolean pullBoolean(String string) throws ParseException {
        Iterator<Object> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Boolean)) continue;
            iterator.remove();
            return (Boolean)object;
        }
        throw this.missingComponent(string);
    }

    public String pullString(String string) throws ParseException {
        Iterator<Object> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof String)) continue;
            iterator.remove();
            return (String)object;
        }
        throw this.missingComponent(string);
    }

    public Object pullObject(String string) throws ParseException {
        Iterator<Object> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == null || object instanceof Element) continue;
            iterator.remove();
            return object;
        }
        throw this.missingComponent(string);
    }

    public Element pullElement(int n, String ... stringArray) throws ParseException {
        Iterator<Object> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            if (element.isEnumeration) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!element.keyword.equalsIgnoreCase(stringArray[i])) continue;
                element.keywordIndex = (byte)i;
                iterator.remove();
                return element;
            }
            if (n != 0) continue;
            return null;
        }
        if (n != 2) {
            return null;
        }
        throw this.missingComponent(stringArray[0]);
    }

    public Element pullVoidElement(String string) throws ParseException {
        Iterator<Object> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            if (!element.isEnumeration) continue;
            iterator.remove();
            return element;
        }
        throw this.missingComponent(string);
    }

    public <T> T pullOptional(Class<T> clazz) {
        Iterator<Object> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!clazz.isInstance(object) || object instanceof Element) continue;
            iterator.remove();
            return (T)object;
        }
        return null;
    }

    final Object[] getChildren() {
        return this.isEnumeration ? null : this.children.toArray();
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    final int getKeywordIndex() {
        return Byte.toUnsignedInt(this.keywordIndex);
    }

    final void close(Map<String, List<String>> map) throws ParseException {
        for (Object object : this.children) {
            if (object instanceof Element) {
                CollectionsExt.addToMultiValuesMap(map, (Object)((Element)object).keyword, (Object)this.keyword);
                continue;
            }
            throw new UnparsableObjectException(this.errorLocale, 144, new Object[]{this.keyword, object}, this.offsetAfterKeyword());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.format(stringBuilder, 0, System.lineSeparator());
        return stringBuilder.toString();
    }

    private void format(StringBuilder stringBuilder, int n, String string) {
        stringBuilder.append(CharSequences.spaces((int)n)).append(this.keyword);
        if (!this.isEnumeration) {
            stringBuilder.append('[');
            n += 4;
            boolean bl = false;
            for (Object object : this.children) {
                if (object instanceof Element) {
                    if (bl) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(string);
                    ((Element)object).format(stringBuilder, n, string);
                } else {
                    boolean bl2 = object instanceof CharSequence;
                    if (bl) {
                        stringBuilder.append(", ");
                    }
                    if (bl2) {
                        stringBuilder.append('\u201c');
                    }
                    stringBuilder.append(object);
                    if (bl2) {
                        stringBuilder.append('\u201d');
                    }
                }
                bl = true;
            }
            stringBuilder.append(']');
        }
    }
}

