/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.metadata.NameMeaning;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.MultiAuthoritiesFactory;
import org.apache.sis.util.Classes;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;

final class AuthorityFactoryIdentifier {
    private static final Locale IDENTIFIER_LOCALE = Locale.US;
    static final byte CRS = 0;
    static final byte CS = 1;
    static final byte DATUM = 2;
    static final byte OPERATION = 3;
    static final byte GEODETIC = 4;
    static final byte ANY = 5;
    private static final Class<? extends AuthorityFactory>[] TYPES = new Class[6];
    final byte type;
    private String authority;
    private String version;

    private AuthorityFactoryIdentifier(byte by, String string, String string2) {
        this.type = by;
        this.authority = string;
        this.version = string2;
    }

    static AuthorityFactoryIdentifier create(Class<? extends AuthorityFactory> clazz, String string, String string2) {
        for (byte by = 0; by < TYPES.length; by = (byte)(by + 1)) {
            if (!TYPES[by].isAssignableFrom(clazz)) continue;
            return AuthorityFactoryIdentifier.create(by, string, string2);
        }
        throw new IllegalArgumentException();
    }

    static AuthorityFactoryIdentifier create(byte by, String string, String string2) {
        return new AuthorityFactoryIdentifier(by, string.toUpperCase(IDENTIFIER_LOCALE), string2 == null ? null : string2.toLowerCase(IDENTIFIER_LOCALE));
    }

    AuthorityFactoryIdentifier unversioned(String string) {
        if (this.version == null && string.equals(this.authority)) {
            return this;
        }
        return new AuthorityFactoryIdentifier(this.type, string.toUpperCase(IDENTIFIER_LOCALE), null);
    }

    AuthorityFactoryIdentifier versionOf(Citation citation) {
        String string = NameMeaning.getVersion((Citation)citation);
        if (string != null) {
            string = string.toLowerCase(IDENTIFIER_LOCALE);
        }
        if (Objects.equals(this.version, string)) {
            return this;
        }
        return new AuthorityFactoryIdentifier(this.type, this.authority, string);
    }

    AuthorityFactoryIdentifier newType(byte by) {
        return new AuthorityFactoryIdentifier(by, this.authority, this.version);
    }

    AuthorityFactoryIdentifier intern() {
        this.authority = this.authority.intern();
        if (this.version != null) {
            this.version = this.version.intern();
        }
        return this;
    }

    public int hashCode() {
        return this.type + 31 * this.authority.hashCode() + Objects.hashCode(this.version);
    }

    public boolean equals(Object object) {
        if (object instanceof AuthorityFactoryIdentifier) {
            AuthorityFactoryIdentifier authorityFactoryIdentifier = (AuthorityFactoryIdentifier)object;
            if (this.type == authorityFactoryIdentifier.type && this.authority.equals(authorityFactoryIdentifier.authority)) {
                return Objects.equals(this.version, authorityFactoryIdentifier.version);
            }
        }
        return false;
    }

    boolean isSameAuthority(AuthorityFactoryIdentifier authorityFactoryIdentifier) {
        return this.authority.equals(authorityFactoryIdentifier.authority);
    }

    CharSequence getAuthorityAndVersion() {
        String string = this.authority;
        if (this.hasVersion()) {
            string = Vocabulary.formatInternational((short)218, (Object[])new Object[]{string, this.version});
        }
        return string;
    }

    boolean hasVersion() {
        return this.version != null;
    }

    void logConflict(AuthorityFactory authorityFactory) {
        this.log(Resources.forLocale(null).getLogRecord(Level.WARNING, (short)19, TYPES[this.type], this.getAuthorityAndVersion(), Classes.getClass((Object)authorityFactory)));
    }

    void logFallback() {
        this.log(Resources.forLocale(null).getLogRecord(Level.WARNING, (short)17, this.authority, this.version));
    }

    private void log(LogRecord logRecord) {
        logRecord.setLoggerName("org.apache.sis.referencing.factory");
        Logging.log(MultiAuthoritiesFactory.class, (String)"getAuthorityFactory", (LogRecord)logRecord);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Classes.getShortName(TYPES[this.type])).append(':').append(this.authority);
        if (this.version != null) {
            stringBuilder.append(':').append(this.version);
        }
        return stringBuilder.toString();
    }

    static {
        AuthorityFactoryIdentifier.TYPES[0] = CRSAuthorityFactory.class;
        AuthorityFactoryIdentifier.TYPES[1] = CSAuthorityFactory.class;
        AuthorityFactoryIdentifier.TYPES[2] = DatumAuthorityFactory.class;
        AuthorityFactoryIdentifier.TYPES[3] = CoordinateOperationAuthorityFactory.class;
        AuthorityFactoryIdentifier.TYPES[4] = GeodeticAuthorityFactory.class;
        AuthorityFactoryIdentifier.TYPES[5] = AuthorityFactory.class;
    }
}

