/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.internal.referencing.GeodeticObjectBuilder;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.TransverseMercator;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.factory.FilteredCodes;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public class CommonAuthorityFactory
extends GeodeticAuthorityFactory
implements CRSAuthorityFactory {
    private static final String AUTO2 = "AUTO2";
    private static final Set<String> CODESPACES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("OGC", "CRS", "AUTO", "AUTO2")));
    private static final int LEGACY_MASK = Integer.MIN_VALUE;
    private static final int FIRST_PROJECTION_CODE = 42001;
    private static final String[] PROJECTION_NAMES = new String[]{"WGS 84 / Auto UTM", "WGS 84 / Auto Tr. Mercator", "WGS 84 / Auto Orthographic", "WGS 84 / Auto Equirectangular", "WGS 84 / Auto Mollweide"};
    static final char SEPARATOR = ',';
    private final Map<String, Class<?>> codes = new LinkedHashMap();
    private volatile CartesianCS projectedCS;

    @Override
    public Citation getAuthority() {
        return Citations.WMS;
    }

    static String reformat(String string) {
        try {
            return CommonAuthorityFactory.format(Integer.parseInt(string.substring(CommonAuthorityFactory.skipNamespace(string) & Integer.MAX_VALUE)));
        }
        catch (NumberFormatException | NoSuchAuthorityCodeException throwable) {
            Logging.recoverableException((Logger)Logging.getLogger((String)"org.apache.sis.referencing.factory"), CommonAuthorityFactory.class, (String)"reformat", (Throwable)throwable);
            return null;
        }
    }

    private static int skipNamespace(String string) throws NoSuchAuthorityCodeException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = string.indexOf(58);
        if (n4 >= 0 && !CommonAuthorityFactory.regionMatches("CRS", string, n2 = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)0, (int)(n = CharSequences.skipTrailingWhitespaces((CharSequence)string, (int)0, (int)n4))), n) && !CommonAuthorityFactory.regionMatches("OGC", string, n2, n)) {
            boolean bl = false;
            int n5 = AUTO2.length() - 1;
            if (string.regionMatches(true, n2, AUTO2, 0, n5)) {
                switch (n - n2 - n5) {
                    case 0: {
                        bl = true;
                        n3 = Integer.MIN_VALUE;
                        break;
                    }
                    case 1: {
                        char c = string.charAt(n - 1);
                        boolean bl2 = bl = c >= '1' && c <= '2';
                        if (c != '1') break;
                        n3 = Integer.MIN_VALUE;
                    }
                }
            }
            if (!bl) {
                throw new NoSuchAuthorityCodeException(Resources.format((short)66, CharSequences.trimWhitespaces((CharSequence)string, (int)0, (int)n4)), "OGC", string);
            }
        }
        if (string.regionMatches(true, n4 = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)(n4 + 1), (int)string.length()), "CRS", 0, "CRS".length())) {
            n4 = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)(n4 + "CRS".length()), (int)string.length());
        }
        if (n4 >= string.length()) {
            throw new NoSuchAuthorityCodeException(Errors.format((short)29, (Object)"code"), "OGC", string);
        }
        return n4 | n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"type", clazz);
        if (!clazz.isAssignableFrom(SingleCRS.class) && !SingleCRS.class.isAssignableFrom(clazz)) {
            return Collections.emptySet();
        }
        Map<String, Class<?>> map = this.codes;
        synchronized (map) {
            if (this.codes.isEmpty()) {
                this.add(1, EngineeringCRS.class);
                this.add(27, GeographicCRS.class);
                this.add(83, GeographicCRS.class);
                this.add(84, GeographicCRS.class);
                this.add(88, VerticalCRS.class);
                for (int i = 42001; i < 42001 + PROJECTION_NAMES.length; ++i) {
                    this.add(i, ProjectedCRS.class);
                }
            }
        }
        return new FilteredCodes(this.codes, clazz).keySet();
    }

    private static String format(int n) {
        return (n >= 42001 ? AUTO2 : "CRS") + ':' + n;
    }

    private void add(int n, Class<? extends SingleCRS> clazz) throws FactoryException {
        assert (n >= 42001 == ProjectedCRS.class.isAssignableFrom(clazz)) : n;
        if (this.codes.put(CommonAuthorityFactory.format(n), clazz) != null) {
            throw new FactoryException();
        }
    }

    @Override
    public Set<String> getCodeSpaces() {
        return CODESPACES;
    }

    @Override
    public InternationalString getDescriptionText(String string) throws FactoryException {
        int n = CommonAuthorityFactory.skipNamespace(string) & Integer.MAX_VALUE;
        String string2 = string.substring(n, CharSequences.skipTrailingWhitespaces((CharSequence)string, (int)n, (int)string.length()));
        if (string2.indexOf(44) < 0) {
            int n2;
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw CommonAuthorityFactory.noSuchAuthorityCode(string2, string, numberFormatException);
            }
            int n3 = n2 - 42001;
            if (n3 >= 0 && n3 < PROJECTION_NAMES.length) {
                return new SimpleInternationalString(PROJECTION_NAMES[n3]);
            }
        }
        return new SimpleInternationalString(this.createCoordinateReferenceSystem(string2).getName().getCode());
    }

    @Override
    public IdentifiedObject createObject(String string) throws FactoryException {
        return this.createCoordinateReferenceSystem(string);
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws FactoryException {
        CommonCRS commonCRS;
        ArgumentChecks.ensureNonNull((String)"code", (Object)string);
        String string2 = null;
        int n = CommonAuthorityFactory.skipNamespace(string);
        boolean bl = (n & Integer.MIN_VALUE) != 0;
        int n2 = string.indexOf(44, n &= Integer.MAX_VALUE);
        int n3 = CharSequences.skipTrailingWhitespaces((CharSequence)string, (int)n, (int)string.length());
        if (n2 >= 0) {
            string2 = string.substring(n2 + 1);
            n3 = CharSequences.skipTrailingWhitespaces((CharSequence)string, (int)n, (int)n2);
        }
        String string3 = string.substring(n, n3);
        n = 0;
        double[] dArray = ArraysExt.EMPTY_DOUBLE;
        try {
            n = Integer.parseInt(string3);
            if (string2 != null) {
                dArray = CharSequences.parseDoubles((CharSequence)string2, (char)',');
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw CommonAuthorityFactory.noSuchAuthorityCode(string3, string, numberFormatException);
        }
        n3 = dArray.length;
        if (n >= 42001) {
            short s = 0;
            int n4 = 2;
            if (n3 < 2) {
                s = 127;
            } else {
                n4 = 3;
                if (n3 > 3) {
                    s = 129;
                }
            }
            if (s == 0) {
                return this.createAuto(string, n, bl, n3 > 2 ? dArray[0] : (bl ? 9001.0 : 1.0), dArray[n3 - 2], dArray[n3 - 1]);
            }
            throw new NoSuchAuthorityCodeException(Errors.format((short)s, (Object)n4, (Object)n3), AUTO2, string3, string);
        }
        if (n3 != 0) {
            throw new NoSuchAuthorityCodeException(Errors.format((short)135, (Object)string3, (Object)string2), "CRS", string3, string);
        }
        switch (n) {
            case 1: {
                return CommonCRS.Engineering.GEODISPLAY.crs();
            }
            case 84: {
                commonCRS = CommonCRS.WGS84;
                break;
            }
            case 83: {
                commonCRS = CommonCRS.NAD83;
                break;
            }
            case 27: {
                commonCRS = CommonCRS.NAD27;
                break;
            }
            case 88: {
                return CommonCRS.Vertical.NAVD88.crs();
            }
            default: {
                throw CommonAuthorityFactory.noSuchAuthorityCode(string3, string, null);
            }
        }
        return commonCRS.normalizedGeographic();
    }

    private ProjectedCRS createAuto(String string, int n, boolean bl, double d, double d2, double d3) throws FactoryException {
        Boolean bl2 = null;
        String string2 = null;
        String string3 = null;
        switch (n) {
            case 42001: {
                bl2 = true;
                break;
            }
            case 42002: {
                bl2 = d3 == 0.0 && TransverseMercator.Zoner.UTM.centralMeridian(TransverseMercator.Zoner.UTM.zone(0.0, d2)) == d2;
                break;
            }
            case 42003: {
                string2 = "Orthographic";
                string3 = "latitude_of_origin";
                break;
            }
            case 42004: {
                string2 = "Equirectangular";
                string3 = "standard_parallel_1";
                break;
            }
            case 42005: {
                string2 = "Mollweide";
                break;
            }
            default: {
                throw CommonAuthorityFactory.noSuchAuthorityCode(String.valueOf(n), string, null);
            }
        }
        CommonCRS commonCRS = CommonCRS.WGS84;
        try {
            Unit unit;
            CartesianCS cartesianCS;
            GeographicCRS geographicCRS;
            ProjectedCRS projectedCRS;
            if (bl2 != null && bl2.booleanValue()) {
                projectedCRS = commonCRS.universal(Math.signum(d3), d2);
                if (d == (double)(bl ? 9001 : 1)) {
                    return projectedCRS;
                }
                geographicCRS = projectedCRS.getBaseCRS();
                cartesianCS = projectedCRS.getCoordinateSystem();
            } else {
                cartesianCS = this.projectedCS;
                if (cartesianCS == null) {
                    projectedCRS = commonCRS.universal(Math.signum(d3), d2);
                    this.projectedCS = cartesianCS = projectedCRS.getCoordinateSystem();
                    geographicCRS = projectedCRS.getBaseCRS();
                } else {
                    projectedCRS = null;
                    geographicCRS = commonCRS.geographic();
                }
            }
            if (bl) {
                unit = CommonAuthorityFactory.createUnitFromEPSG(d).asType(Length.class);
            } else {
                unit = Units.METRE;
                if (d != 1.0) {
                    unit = unit.multiply(d);
                }
            }
            if (!Units.METRE.equals((Object)unit)) {
                cartesianCS = (CartesianCS)CoordinateSystems.replaceLinearUnit((CoordinateSystem)cartesianCS, (Unit<Length>)unit);
            }
            GeodeticObjectBuilder geodeticObjectBuilder = new GeodeticObjectBuilder();
            if (bl2 != null) {
                if (bl2.booleanValue() && projectedCRS != null) {
                    geodeticObjectBuilder.addName(projectedCRS.getName());
                }
                geodeticObjectBuilder.setTransverseMercator(bl2 != false ? TransverseMercator.Zoner.UTM : TransverseMercator.Zoner.ANY, d3, d2);
            } else {
                ((GeodeticObjectBuilder)geodeticObjectBuilder.setConversionMethod(string2).addName(PROJECTION_NAMES[n - 42001])).setParameter("central_meridian", d2, Units.DEGREE);
                if (string3 != null) {
                    geodeticObjectBuilder.setParameter(string3, d3, Units.DEGREE);
                }
            }
            return geodeticObjectBuilder.createProjectedCRS(geographicCRS, cartesianCS);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw CommonAuthorityFactory.noSuchAuthorityCode(String.valueOf(n), string, illegalArgumentException);
        }
    }

    private static Unit<?> createUnitFromEPSG(double d) throws NoSuchAuthorityCodeException {
        String string;
        String string2 = null;
        int n = (int)d;
        if ((double)n == d) {
            Unit unit = Units.valueOfEPSG((int)n);
            if (Units.isLinear((Unit)unit)) {
                return unit;
            }
            if (unit != null) {
                string2 = Errors.format((short)103, (Object)unit);
            }
            string = String.valueOf(n);
        } else {
            string = String.valueOf(d);
        }
        if (string2 == null) {
            string2 = Resources.format((short)49, "EPSG", Unit.class, string);
        }
        throw new NoSuchAuthorityCodeException(string2, "EPSG", string);
    }

    private static NoSuchAuthorityCodeException noSuchAuthorityCode(String string, String string2, Exception exception) {
        return (NoSuchAuthorityCodeException)new NoSuchAuthorityCodeException(Resources.format((short)49, "OGC", CoordinateReferenceSystem.class, string), "OGC", string, string2).initCause((Throwable)exception);
    }
}

