/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;

abstract class AuthalicConversion
extends NormalizedProjection {
    private static final long serialVersionUID = 5880625564193782957L;
    private static final double ECCENTRICITY_THRESHOLD = 0.1;
    private final double c2\u03b2;
    private final double c4\u03b2;
    private final double c6\u03b2;
    final double qmPolar;
    final boolean isSpherical;
    private final boolean useIterations;

    AuthalicConversion(Initializer initializer, NormalizedProjection normalizedProjection) {
        super(initializer, normalizedProjection);
        this.isSpherical = this.eccentricitySquared == 0.0;
        double d = this.eccentricitySquared;
        double d2 = d * d;
        double d3 = d * d2;
        this.c2\u03b2 = 0.5714285714285714 * d3 + 0.6 * d2 + 0.6666666666666666 * d;
        this.c4\u03b2 = -1.0680776014109348 * d3 + -0.5111111111111111 * d2;
        this.c6\u03b2 = 0.5368606701940035 * d3;
        this.qmPolar = this.qm(1.0);
        this.useIterations = this.eccentricity >= 0.1;
    }

    AuthalicConversion(AuthalicConversion authalicConversion) {
        super(null, authalicConversion);
        this.c2\u03b2 = authalicConversion.c2\u03b2;
        this.c4\u03b2 = authalicConversion.c4\u03b2;
        this.c6\u03b2 = authalicConversion.c6\u03b2;
        this.qmPolar = authalicConversion.qmPolar;
        this.isSpherical = authalicConversion.isSpherical;
        this.useIterations = authalicConversion.useIterations;
    }

    final double qm(double d) {
        if (this.isSpherical) {
            return 2.0 * d;
        }
        double d2 = this.eccentricity * d;
        return d / (1.0 - d2 * d2) + MathFunctions.atanh((double)d2) / this.eccentricity;
    }

    final double dqm_d\u03c6(double d, double d2) {
        double d3 = 1.0 - this.eccentricitySquared * (d * d);
        return 2.0 * d2 / (d3 * d3);
    }

    final double sin\u03b2(double d) {
        if (this.isSpherical) {
            return d;
        }
        return ((d *= this.eccentricity) / (1.0 - d * d) + MathFunctions.atanh((double)d)) / (this.eccentricity * this.qmPolar);
    }

    final double \u03c6(double d) throws ProjectionException {
        double d2;
        double d3 = d * d;
        double d4 = Math.asin(d);
        double d5 = d4 + Math.cos(d4) * d * (this.c2\u03b2 + d3 * (this.c4\u03b2 + d3 * this.c6\u03b2));
        if (this.useIterations) {
            d2 = this.qmPolar * d;
            for (int i = 0; i < 18; ++i) {
                double d6 = Math.sin(d5);
                double d7 = Math.cos(d5);
                double d8 = this.eccentricity * d6;
                double d9 = 1.0 - d8 * d8;
                double d10 = d9 * d9 / (2.0 * d7) * (d2 - d6 / d9 - MathFunctions.atanh((double)d8) / this.eccentricity);
                d5 += d10;
                if (!(Math.abs(d10) <= 3.926676682852614E-10)) continue;
                return d5;
            }
        } else if (!Double.isNaN(d5)) {
            return d5;
        }
        if (Math.abs((d2 = Math.abs(d)) - 1.0) < 1.5706706731410455E-9) {
            double d11 = this.qmPolar * d;
            return Math.copySign(1.5707963267948966, d11);
        }
        if (!(d2 < 1.0)) {
            return Double.NaN;
        }
        throw new ProjectionException(Resources.format((short)46));
    }
}

