/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock;

import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.database.utils.JDBCUtils;
import org.exoplatform.services.jcr.config.LockManagerEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.checker.InspectionQuery;
import org.exoplatform.services.jcr.impl.core.lock.LockTableHandler;

public abstract class AbstractLockTableHandler
implements LockTableHandler {
    protected final WorkspaceEntry workspaceEntry;
    protected final LockManagerEntry lockManagerEntry;
    final DataSource ds;

    public AbstractLockTableHandler(WorkspaceEntry workspaceEntry, DataSource ds) {
        this.workspaceEntry = workspaceEntry;
        this.lockManagerEntry = workspaceEntry.getLockManager();
        this.ds = ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getLockedNodesIds() throws SQLException {
        HashSet<String> lockedNodesIds = new HashSet<String>();
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        Connection jdbcConnection = this.openConnection();
        try {
            InspectionQuery query = this.getSelectQuery();
            preparedStatement = jdbcConnection.prepareStatement(query.getStatement());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String idColumn = query.getFieldNames()[0];
                String idValue = resultSet.getString(idColumn);
                lockedNodesIds.add(this.extractNodeId(idValue));
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.freeResources(resultSet, preparedStatement, (Connection)jdbcConnection);
            throw throwable;
        }
        JDBCUtils.freeResources((ResultSet)resultSet, (Statement)preparedStatement, (Connection)jdbcConnection);
        return lockedNodesIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLockedNode(String nodeId) throws SQLException {
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        Connection jdbcConnection = this.openConnection();
        try {
            InspectionQuery query = this.getDeleteQuery(nodeId);
            preparedStatement = jdbcConnection.prepareStatement(query.getStatement());
            preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            JDBCUtils.freeResources(resultSet, preparedStatement, (Connection)jdbcConnection);
            throw throwable;
        }
        JDBCUtils.freeResources(resultSet, (Statement)preparedStatement, (Connection)jdbcConnection);
    }

    protected Connection openConnection() throws SQLException {
        return (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

            @Override
            public Connection run() throws SQLException {
                return AbstractLockTableHandler.this.ds.getConnection();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanLocks() throws SQLException {
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        Connection jdbcConnection = this.openConnection();
        try {
            InspectionQuery query = this.getDeleteAllQuery();
            preparedStatement = jdbcConnection.prepareStatement(query.getStatement());
            preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            JDBCUtils.freeResources(resultSet, preparedStatement, (Connection)jdbcConnection);
            throw throwable;
        }
        JDBCUtils.freeResources(resultSet, (Statement)preparedStatement, (Connection)jdbcConnection);
    }

    protected abstract String extractNodeId(String var1);

    protected abstract InspectionQuery getDeleteQuery(String var1) throws SQLException;

    protected abstract InspectionQuery getDeleteAllQuery() throws SQLException;

    protected abstract InspectionQuery getSelectQuery() throws SQLException;
}

