/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.query.lucene.AggregateRule;
import org.exoplatform.services.jcr.util.Text;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class AggregateRuleImpl
implements AggregateRule {
    private final LocationFactory resolver;
    private final InternalQName nodeTypeName;
    private final NodeInclude[] nodeIncludes;
    private final PropertyInclude[] propertyIncludes;
    private final ItemDataConsumer ism;

    AggregateRuleImpl(Node config, LocationFactory resolver, ItemDataConsumer ism) throws IllegalNameException, RepositoryException {
        this.resolver = resolver;
        this.nodeTypeName = this.getNodeTypeName(config);
        this.nodeIncludes = this.getNodeIncludes(config);
        this.propertyIncludes = this.getPropertyIncludes(config);
        this.ism = ism;
    }

    @Override
    public NodeData getAggregateRoot(NodeData nodeState) throws RepositoryException {
        NodeData aggregateRoot;
        int i;
        for (i = 0; i < this.nodeIncludes.length; ++i) {
            aggregateRoot = this.nodeIncludes[i].matches(nodeState);
            if (aggregateRoot == null || !aggregateRoot.getPrimaryTypeName().equals((Object)this.nodeTypeName)) continue;
            return aggregateRoot;
        }
        for (i = 0; i < this.propertyIncludes.length; ++i) {
            aggregateRoot = this.propertyIncludes[i].matches(nodeState);
            if (aggregateRoot == null || !aggregateRoot.getPrimaryTypeName().equals((Object)this.nodeTypeName)) continue;
            return aggregateRoot;
        }
        return null;
    }

    @Override
    public NodeData[] getAggregatedNodeStates(NodeData nodeState) throws RepositoryException {
        if (nodeState.getPrimaryTypeName().equals((Object)this.nodeTypeName)) {
            ArrayList<NodeData> nodeStates = new ArrayList<NodeData>();
            for (int i = 0; i < this.nodeIncludes.length; ++i) {
                nodeStates.addAll(Arrays.asList(this.nodeIncludes[i].resolve(nodeState)));
            }
            if (nodeStates.size() > 0) {
                return nodeStates.toArray(new NodeData[nodeStates.size()]);
            }
        }
        return null;
    }

    @Override
    public PropertyData[] getAggregatedPropertyStates(NodeData nodeState) throws RepositoryException {
        if (nodeState.getPrimaryTypeName().equals((Object)this.nodeTypeName)) {
            ArrayList<PropertyData> propStates = new ArrayList<PropertyData>();
            for (int i = 0; i < this.propertyIncludes.length; ++i) {
                propStates.addAll(Arrays.asList(this.propertyIncludes[i].resolvePropertyStates(nodeState)));
            }
            if (propStates.size() > 0) {
                return propStates.toArray(new PropertyData[propStates.size()]);
            }
        }
        return null;
    }

    private InternalQName getNodeTypeName(Node config) throws IllegalNameException, RepositoryException {
        String ntString = config.getAttributes().getNamedItem("primaryType").getNodeValue();
        return this.resolver.parseJCRName(ntString).getInternalName();
    }

    private NodeInclude[] getNodeIncludes(Node config) throws IllegalNameException, RepositoryException {
        ArrayList<NodeInclude> includes = new ArrayList<NodeInclude>();
        NodeList childNodes = config.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (!n.getNodeName().equals("include")) continue;
            InternalQName ntName = null;
            Node ntAttr = n.getAttributes().getNamedItem("primaryType");
            if (ntAttr != null) {
                ntName = this.resolver.parseJCRName(ntAttr.getNodeValue()).getInternalName();
            }
            String[] elements = Text.explode(AggregateRuleImpl.getTextContent(n), 47);
            QPathEntry[] path = new QPathEntry[elements.length];
            for (int j = 0; j < elements.length; ++j) {
                path[j] = elements[j].equals("*") ? new QPathEntry(Constants.JCR_ANY_NAME, 0) : new QPathEntry(this.resolver.parseJCRName(elements[j]).getInternalName(), 0);
            }
            includes.add(new NodeInclude(new QPath(path), ntName));
        }
        return includes.toArray(new NodeInclude[includes.size()]);
    }

    private PropertyInclude[] getPropertyIncludes(Node config) throws IllegalNameException, RepositoryException {
        ArrayList<PropertyInclude> includes = new ArrayList<PropertyInclude>();
        NodeList childNodes = config.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (!n.getNodeName().equals("include-property")) continue;
            String[] elements = Text.explode(AggregateRuleImpl.getTextContent(n), 47);
            QPathEntry[] path = new QPathEntry[elements.length];
            for (int j = 0; j < elements.length; ++j) {
                if (elements[j].equals("*")) {
                    throw new IllegalNameException("* not supported in include-property");
                }
                path[j] = new QPathEntry(this.resolver.parseJCRName(elements[j]).getInternalName(), 1);
            }
            includes.add(new PropertyInclude(new QPath(path)));
        }
        return includes.toArray(new PropertyInclude[includes.size()]);
    }

    private static String getTextContent(Node node) {
        StringBuilder content = new StringBuilder();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() != 3) continue;
            content.append(((CharacterData)n).getData());
        }
        return content.toString();
    }

    private final class NodeInclude
    extends AbstractInclude {
        NodeInclude(QPath pattern, InternalQName nodeTypeName) {
            super(pattern, nodeTypeName);
        }

        NodeData[] resolve(NodeData nodeState) throws RepositoryException {
            ArrayList<NodeData> nodeStates = new ArrayList<NodeData>();
            this.resolve(nodeState, nodeStates, 0);
            return nodeStates.toArray(new NodeData[nodeStates.size()]);
        }
    }

    private final class PropertyInclude
    extends AbstractInclude {
        private final InternalQName propertyName;

        PropertyInclude(QPath pattern) throws PathNotFoundException, IllegalPathException {
            super(new QPath(pattern.getRelPath(1)), null);
            this.propertyName = pattern.getName();
        }

        PropertyData[] resolvePropertyStates(NodeData nodeState) throws RepositoryException {
            ArrayList<NodeData> nodeStates = new ArrayList<NodeData>();
            this.resolve(nodeState, nodeStates, 0);
            ArrayList<PropertyData> propStates = new ArrayList<PropertyData>();
            for (NodeData state : nodeStates) {
                ItemData prop = AggregateRuleImpl.this.ism.getItemData(state, new QPathEntry(this.propertyName, 1), ItemType.PROPERTY);
                if (prop == null || prop.isNode()) continue;
                propStates.add((PropertyData)prop);
            }
            return propStates.toArray(new PropertyData[propStates.size()]);
        }
    }

    private abstract class AbstractInclude {
        protected final InternalQName nodeTypeName;
        protected final QPath pattern;

        AbstractInclude(QPath pattern, InternalQName nodeTypeName) {
            this.nodeTypeName = nodeTypeName;
            this.pattern = pattern;
        }

        NodeData matches(NodeData nodeState) throws RepositoryException {
            if (this.nodeTypeName == null || nodeState.getPrimaryTypeName().equals((Object)this.nodeTypeName)) {
                QPathEntry[] elements = this.pattern.getEntries();
                for (int e = elements.length - 1; e >= 0; --e) {
                    String parentId = nodeState.getParentIdentifier();
                    if (parentId == null) {
                        return null;
                    }
                    NodeData parent = (NodeData)AggregateRuleImpl.this.ism.getItemData(parentId);
                    if (elements[e].getName().equals("*")) {
                        nodeState = parent;
                        continue;
                    }
                    InternalQName name = nodeState.getQPath().getName();
                    if (elements[e].equals((Object)name)) {
                        nodeState = parent;
                        continue;
                    }
                    return null;
                }
                return nodeState;
            }
            return null;
        }

        protected void resolve(NodeData nodeState, List<NodeData> collector, int offset) throws RepositoryException {
            List<Object> cne;
            QPathEntry currentName = this.pattern.getEntries()[offset];
            if (currentName.getAsString().equals("*")) {
                cne = AggregateRuleImpl.this.ism.getChildNodesData(nodeState);
            } else {
                cne = new ArrayList();
                ItemData item = AggregateRuleImpl.this.ism.getItemData(nodeState, currentName, ItemType.NODE);
                if (item != null && item.isNode()) {
                    cne.add((NodeData)item);
                }
            }
            if (this.pattern.getEntries().length - 1 == offset) {
                for (NodeData nodeData : cne) {
                    if (this.nodeTypeName != null && (nodeData == null || !nodeData.getPrimaryTypeName().equals((Object)this.nodeTypeName))) continue;
                    collector.add(nodeData);
                }
            } else {
                ++offset;
                for (NodeData nodeData : cne) {
                    if (nodeData == null) continue;
                    this.resolve(nodeData, collector, offset);
                }
            }
        }
    }
}

