/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;

public class ScorerWrapper
extends Scorer {
    List<DocData> docs = new ArrayList<DocData>();
    int index;
    DocData currentDocData = null;
    CollectorWrapper collectorWrapper = new CollectorWrapper();

    protected ScorerWrapper(Similarity similarity) {
        super(similarity);
    }

    public float score() throws IOException {
        if (this.currentDocData != null) {
            return this.currentDocData.score;
        }
        return 0.0f;
    }

    public int docID() {
        if (this.currentDocData != null) {
            return this.currentDocData.docID;
        }
        return Integer.MAX_VALUE;
    }

    public int nextDoc() throws IOException {
        if (this.index < this.docs.size()) {
            this.currentDocData = this.docs.get(this.index);
            ++this.index;
            return this.currentDocData.docID;
        }
        this.currentDocData = null;
        return Integer.MAX_VALUE;
    }

    public int advance(int target) throws IOException {
        int doc;
        while ((doc = this.nextDoc()) < target) {
            if (doc != Integer.MAX_VALUE && doc != -1) continue;
            return Integer.MAX_VALUE;
        }
        return doc;
    }

    public Collector getCollector() {
        return this.collectorWrapper;
    }

    static class DocData {
        public int docID;
        public float freq;
        public float score;

        public DocData(int docID, float freq, float score) {
            this.docID = docID;
            this.freq = freq;
            this.score = score;
        }
    }

    class CollectorWrapper
    extends Collector {
        private Scorer subScrorer;

        CollectorWrapper() {
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.subScrorer = scorer;
        }

        public void collect(int doc) throws IOException {
            ScorerWrapper.this.docs.add(new DocData(doc, this.subScrorer.freq(), this.subScrorer.score()));
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }
}

